#pragma once

#include "query.h"
#include "crypto/decryptor.h"
#include "crypto/encryptor.h"
#include "depends/ipreg.h"
#include "depends/uatraits.h"
#include "sampler/sampler.h"
#include "yt_converters/tables_lifetime_config.h"

#include <passport/infra/libs/cpp/geobase/geobase.h>
#include <passport/infra/libs/cpp/logbroker/processing/processor.h>
#include <passport/infra/libs/cpp/logbroker/processing/reader_pool.h>
#include <passport/infra/libs/cpp/unistat/consumers.h>

#include <array>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NLb {
    class TBaseParser;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLbchdb::NParser {
    struct TAuthRow;
    using TAuthResult = std::vector<TAuthRow>;
}

namespace NPassport::NLbchdb {
    enum class ELogType {
        Auth,
        BlackboxAuth,
        Event,
        MailUserJournal,
        OAuth,
        Push,
        PushSubscription,
        Restore,
        SenderDelivery,
        YasmsPrivate,

        COUNT,
    };

    struct TLogTypeTraits {
        using TType = ELogType;

        static const size_t count_ = (size_t)ELogType::COUNT;

        static TString ToString(ELogType type);
        static ELogType FromString(const TString& type);
    };

    struct TProcessorSettings {
        bool IsLastauthToHbaseEnabled = false;
        bool IsMailToHbaseEnabled = false;
        bool IsMailToYtEnabled = false;
        size_t CompressIfMoreThan = 100 * 1024;
        uint32_t SenderSampleRatio = 100;
        uint32_t AuthSamplingPeriod = 0;
        NSampler::TSamplerSettings AuthSampler;
        NYtConv::TTablesLifeTimeConfig TablesLifeTimeConfig;
        TDuration PushSubscriptionBucketWidth = TDuration::Days(1);
    };

    class TSenderUnsubscribeLists;

    class TProcessor: NLb::TBaseProcessor<TLogTypeTraits> {
        using TBase = NLb::TBaseProcessor<TLogTypeTraits>;

    public:
        TProcessor(const NGeobase::IGeobase& geobase,
                   const IIpReg& ipreg,
                   const IUaTraits& uatraits,
                   const TProcessorSettings& settings,
                   NLb::TBadLineLoggers<TLogTypeTraits> badLinesLoggers,
                   NCrypto::TKeyRingPtr decryptorKeyRing,
                   NCrypto::TEncryptor::TKeyRingMap&& encryptorKeyRingMap,
                   std::unique_ptr<TSenderUnsubscribeLists> unsubscribeLists,
                   NDbPool::TDbPool* blackbox = nullptr,
                   NDbPool::TDbPool* kolmogor = nullptr);
        ~TProcessor();

        void AddUnistat(NUnistat::TBuilder& builder) const;

        TQueries Proc(const NLb::TDataSet<ELogType>& data);

    private:
        TQueries ChooseProc(const NLb::TDataWithType<ELogType>& data);
        TQueries ProcAuth(ELogType logType, const NLb::TData& data);
        TQueries ProcEvent(const NLb::TData& data);
        TQueries ProcMailUserJournal(const NLb::TData& data);
        TQueries ProcOAuth(const NLb::TData& data);
        TQueries ProcRestore(const NLb::TData& data);
        TQueries ProcSenderDelivery(const NLb::TData& data);
        TQueries ProcYasmsPrivate(const NLb::TData& data);
        TQueries ProcPush(const NLb::TData& data);
        TQueries ProcPushSubscription(const NLb::TData& data);

        bool IsSenderDeliveryRowSelected() const;

    private:
        const NGeobase::IGeobase& Geobase_;
        const IIpReg& Ipreg_;
        const IUaTraits& Uatraits_;
        const TProcessorSettings Settings_;
        const NCrypto::TDecryptor Decryptor_;
        const NCrypto::TEncryptor Encryptor_;
        NDbPool::TDbPool* Blackbox_;

        NUnistat::TSignalDiff<> UnistatLastAuthTotal_ = {"lastauth_filter.total"};
        NUnistat::TSignalDiff<> UnistatLastAuthPassed_ = {"lastauth_filter.passed"};
        NUnistat::TSignalDiff<> UnistatBlackboxErrors_ = {"processor.blackbox.errors"};

        NSampler::TBbAuthSampler AuthSampler_;
        NUnistat::TSimpleConsumers MailUserJournalModules_;
        std::unique_ptr<TSenderUnsubscribeLists> UnsubscribeLists_;
    };

    using TProcessorPtr = std::unique_ptr<TProcessor>;
}
