#pragma once

#include <passport/infra/libs/cpp/json/reader.h>
#include <passport/infra/libs/cpp/unistat/absolute.h>
#include <passport/infra/libs/cpp/unistat/diff.h>

#include <library/cpp/cache/cache.h>

#include <util/datetime/base.h>

#include <mutex>
#include <unordered_map>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NLbchdb::NExtend {
    struct TAuthExtendedEntry;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLbchdb::NSampler {
    struct TSamplerSettings {
        size_t EntryLimit = 10000000;
        TString KolmogorSpace;
    };

    class TInternalSamplerStorage {
    public:
        enum class EResult {
            Added,
            Found,
        };

        TInternalSamplerStorage(const TSamplerSettings& settings);

        EResult TryAdd(const TString& key);

    private:
        bool AddToData(const TString& key);

    private:
        std::mutex Mutex_;
        TLRUCache<TString, char> Data_;
    };

    class TBbAuthSampler {
    public:
        TBbAuthSampler(const TSamplerSettings& settings, NDbPool::TDbPool* kolmogor = nullptr);

        void AddUnistat(NUnistat::TBuilder& builder) const;
        void AddStats(ui64 tries, ui64 hit, ui64 kolmogorErrors = 0);

    public:
        const TSamplerSettings& Settings() const {
            return Settings_;
        }

        TInternalSamplerStorage& InternalStorage() {
            return InternalStorage_;
        }

        NDbPool::TDbPool* Kolmogor() const {
            return Kolmogor_;
        }

    private:
        const TSamplerSettings Settings_;

        TInternalSamplerStorage InternalStorage_;
        NDbPool::TDbPool* Kolmogor_;

        NUnistat::TSignalDiff<> UnistatTries_ = {"sampler.tries"};
        NUnistat::TSignalDiff<> UnistatHit_ = {"sampler.hit"};
        NUnistat::TSignalDiff<> UnistatKolmogorErrors_ = {"sampler.kolmogor.errors"};
    };

    class TBbAuthSampleBulk {
    public:
        using TResult = std::vector<NExtend::TAuthExtendedEntry>;

        TBbAuthSampleBulk(TBbAuthSampler& parent);
        ~TBbAuthSampleBulk();

        void Reserve(size_t size);
        void Add(TString&& key, NExtend::TAuthExtendedEntry&& entry);
        TResult Calculate();

    public:
        TString CreateKolmoRequest() const;
        TString PerformRequest(TString&& req) const;
        void ParseResponse(const TString& resp,
                           rapidjson::Document& doc,
                           const rapidjson::Value*& space) const;
        static std::optional<ui64> GetCounterFromResponse(const rapidjson::Value* space, const TString& key);
        static bool WasFoundInKolmogor(std::optional<ui64> val);

    private:
        TBbAuthSampler& Parent_;
        std::unordered_map<TString, NExtend::TAuthExtendedEntry> ToSample_;

        ui64 Tries_ = 0;
        ui64 Hit_ = 0;
    };
}
