#include "sender_unsubsrcibe_lists.h"

#include <passport/infra/libs/cpp/json/reader.h>

#include <util/string/cast.h>

namespace NPassport::NLbchdb {
    TSenderUnsubscribeLists::TSenderUnsubscribeLists(TStringBuf filebody) {
        rapidjson::Document doc;
        Y_ENSURE(NJson::TReader::DocumentAsObject(filebody, doc),
                 "malformed json: " << filebody);

        for (auto it = doc.MemberBegin(); it != doc.MemberEnd(); ++it) {
            const TStringBuf account(it->name.GetString(), it->name.GetStringLength());

            Y_ENSURE(it->value.IsUint64(), "account '" << account << "' is not uint64");
            Data_.emplace(account, it->value.GetUint64());
        }

        Y_ENSURE(!Data_.empty(), "unsubscribe lists are empty");
    }

    ui64 TSenderUnsubscribeLists::GetByAccount(const TStringBuf account) const {
        auto it = Data_.find(account);
        Y_ENSURE(it != Data_.end(), "sender account '" << account << "' is unknown");
        return it->second;
    }
}
