LIBRARY()

OWNER(g:passport_infra)

PEERDIR(
    library/cpp/deprecated/ipreg1
    library/cpp/user_agent
    library/cpp/yson
    library/cpp/yson/json
    passport/infra/daemons/lbchdb/src/proto
    passport/infra/libs/cpp/dbpool
    passport/infra/libs/cpp/geobase
    passport/infra/libs/cpp/hbase
    passport/infra/libs/cpp/idn
    passport/infra/libs/cpp/json
    passport/infra/libs/cpp/juggler
    passport/infra/libs/cpp/logbroker
    passport/infra/libs/cpp/logbroker/entity_parsers
    passport/infra/libs/cpp/tvm/dbpool
    passport/infra/libs/cpp/tvm/common
    passport/infra/libs/cpp/tvm/logger
    passport/infra/libs/cpp/unistat
    passport/infra/libs/cpp/yt
)

SRCS(
    blackbox_client.cpp
    data_pusher.cpp
    lbchdb.cpp
    out.cpp
    processor.cpp
    query.cpp
    sender_unsubsrcibe_lists.cpp
    crypto/decryptor.cpp
    crypto/encryptor.cpp
    crypto/key_ring.cpp
    depends/ipreg.cpp
    depends/uatraits.cpp
    extenders/auth_extender.cpp
    extenders/event_extender.cpp
    extenders/oauth_extender.cpp
    extenders/sender_delivery_extender.cpp
    extenders/utils.cpp
    hbase_converters/aggregate_auth_helper.cpp
    hbase_converters/auth_converter.cpp
    hbase_converters/event_converter.cpp
    hbase_converters/mail_user_journal_converter.cpp
    hbase_converters/oauth_converter.cpp
    hbase_converters/restore_converter.cpp
    hbase_converters/utils.cpp
    hbase_converters/yasms_private_converter.cpp
    hbase_converters/auth/auths.cpp
    hbase_converters/auth/failed_auths.cpp
    hbase_converters/auth/last_auth.cpp
    hbase_converters/auth/oauth.cpp
    hbase_converters/auth/succed_auths.cpp
    hbase_converters/events/common.cpp
    hbase_converters/events/event.cpp
    hbase_converters/events/registration.cpp
    hbase_converters/events/restore_events.cpp
    hbase_converters/mail_user_journal/users_history.cpp
    hbase_converters/yasms_private_converter/yasms_sms_history.cpp
    helpers/auths_helper.cpp
    parsers/auth_parser.cpp
    parsers/event_parser.cpp
    parsers/mail_user_journal_parser.cpp
    parsers/oauth_parser.cpp
    parsers/push_parser.cpp
    parsers/push_subscription_parser.cpp
    parsers/restore_parser.cpp
    parsers/sender_delivery_parser.cpp
    parsers/yasms_private.cpp
    sampler/sampler.cpp
    yt_converters/auth_converter.cpp
    yt_converters/common.cpp
    yt_converters/tables_lifetime_config.cpp
    yt_converters/utils.cpp
    yt_converters/auth/auths.cpp
    yt_converters/auth/last_auth.cpp
    yt_converters/mail_user_journal_converter.cpp
    yt_converters/mail_user_journal/users_history.cpp
    yt_converters/push_converter.cpp
    yt_converters/push_subscription_converter.cpp
    yt_converters/push/entry.cpp
    yt_converters/push/push.cpp
    yt_converters/push/push_by_uid.cpp
    yt_converters/push/push_by_app_id.cpp
    yt_converters/push/push_by_device_id.cpp
    yt_converters/push_subscription/push_subscription.cpp
    yt_converters/restore_converter.cpp
    yt_converters/restore/restore.cpp
    yt_converters/sender_delivery_converter.cpp
    yt_converters/sender_delivery/last_letter.cpp
    yt_converters/yasms_private_converter.cpp
    yt_converters/yasms_private/entry.cpp
    yt_converters/yasms_private/sms_history.cpp
)

GENERATE_ENUM_SERIALIZATION(crypto/encryptor.h)
GENERATE_ENUM_SERIALIZATION(parsers/yasms_private.h)
GENERATE_ENUM_SERIALIZATION(processor.h)
GENERATE_ENUM_SERIALIZATION(sampler/sampler.h)

END()
