#pragma once

#include <passport/infra/daemons/lbchdb/src/extenders/auth_extender.h>

#include <passport/infra/libs/cpp/yt/query.h>

#include <yt/yt/core/yson/string.h>

namespace NPassport::NLbchdb::NYtConv::NAuth {
    struct TAuthEntry {
        static TAuthEntry Create(const NExtend::TAuthExtendedEntry& entry, bool isSamplingEnabled);

        ui64 Uid = 0;
        time_t ReversedTimestamp = 0;
        TString KeyUniquePart;
        TString Type;
        TString Status;
        TString ClientName;
        NYT::NYson::TYsonString Data;
    };

    class TAuthsQueryConverter: public NYt::TBaseConverter<TAuthEntry> {
    public:
        NYt::TWriteQuery Convert(const TString& table, size_t offset, size_t count) const override;
        static NYt::TWriteQuery ConvertImpl(const TString& table, std::span<const TAuthEntry> data);
    };
    using TAuthsQueryConverterPtr = std::unique_ptr<TAuthsQueryConverter>;

    class TAuths {
    public:
        static const TString AUTHS_TABLE_DIR;
        static const TString FAILED_AUTHS_TABLE_NAME;

        static NYt::TTableSchema CreateYtSchema();
    };
}
