#pragma once

#include <passport/infra/daemons/lbchdb/src/extenders/auth_extender.h>

#include <passport/infra/libs/cpp/yt/query.h>

namespace NPassport::NLbchdb::NYtConv::NAuth {
    struct TLastAuthEntry {
        static std::optional<TLastAuthEntry> Create(const NExtend::TAuthExtendedEntry& entry);

        bool operator==(const TLastAuthEntry& o) const {
            return Uid == o.Uid && AuthType == o.AuthType && Timestamp == o.Timestamp;
        }

        ui64 Uid = 0;
        TString AuthType;
        TInstant Timestamp;
    };

    class TLastAuthConverter: public NYt::TBaseConverter<TLastAuthEntry> {
    public:
        NYt::TWriteQuery Convert(
            const TString& table,
            size_t offset,
            size_t count) const override;

        static NYt::TWriteQuery ConvertImpl(
            const TString& table,
            std::span<const TLastAuthEntry> data);
    };
    using TLastAuthConverterPtr = std::unique_ptr<TLastAuthConverter>;

    class TLastAuth {
    public:
        static const TString TABLE_NAME;
    };

    class TLastAuthFilter {
    public:
        using TEntries = std::unordered_map<TString, TLastAuthEntry>;

        void Reserve(size_t size);
        void Add(TLastAuthEntry&& e);

        TEntries ExtractEntries();

    private:
        bool IsFinished_ = false;
        TEntries Entries_;
    };
}
