#pragma once

#include "tables_lifetime_config.h"
#include "auth/auths.h"
#include "auth/last_auth.h"

#include <passport/infra/daemons/lbchdb/src/extenders/auth_extender.h>

#include <passport/infra/libs/cpp/yt/periodic_table.h>
#include <passport/infra/libs/cpp/yt/query.h>

#include <map>

namespace NPassport::NLbchdb::NYtConv {
    class TAuthConverter: TMoveOnly {
    public:
        TAuthConverter(const TTablesLifeTimeConfig& ttlConfig);
        ~TAuthConverter();

        void Reserve(size_t size);

        void ProcessCommon(const NExtend::TAuthExtendedEntry& entry);
        void ProcessSampled(const NExtend::TAuthExtendedEntry& entry, bool isSamplingEnabled);

        NYt::TWriteQueries<TString> Finish(NUnistat::TSignalDiff<>& total, NUnistat::TSignalDiff<>& passed);

    private:
        NAuth::TLastAuthConverterPtr FilterLastAuth();

    private:
        const TTablesLifeTimeConfig& TtlConfig_;

        NAuth::TLastAuthFilter LastAuthFilter_;
        size_t LastAuthTotal_ = 0;

        NAuth::TAuthsQueryConverterPtr FailedAuthsConverter_;
        std::map<NYt::TMonthlyTable, NAuth::TAuthsQueryConverterPtr> AuthsConverters_;
        size_t Reserve_ = 0;

        bool IsFinished_ = false;
    };
}
