#pragma once

#include <passport/infra/daemons/lbchdb/src/crypto/encryptor.h>

#include <util/generic/strbuf.h>

#include <optional>

namespace NYT::NYson {
    class TBufferedBinaryYsonWriter;
}

namespace NPassport::NLbchdb::NYtConv {
    class TCompressor {
    public:
        enum class ECompressionCodec {
            GZip,
            Brotli,
            ZStd,
        };
        static TString Compress(
            const TStringBuf blob,
            ECompressionCodec codec,
            std::optional<size_t> level = {});
    };

    struct TEncryptionSettings {
        size_t CompressIfMoreThan = 100 * 1024;
        TCompressor::ECompressionCodec Codec = TCompressor::ECompressionCodec::GZip;
        std::optional<size_t> Level = {};
    };

    class TYsonSerializer {
    public:
        static void SerializeEncrypted(NYT::NYson::TBufferedBinaryYsonWriter& writer,
                                       const TStringBuf blob,
                                       const NCrypto::TEncryptor& encryptor,
                                       NCrypto::TEncryptor::EKeyRing ring,
                                       const TEncryptionSettings& settings = {});
    };
}
