#pragma once

#include <passport/infra/daemons/lbchdb/src/parsers/mail_user_journal_parser.h>

#include <passport/infra/libs/cpp/yt/query.h>

#include <yt/yt/core/yson/string.h>

namespace NPassport::NLbchdb::NYtConv::NMailUserJournal {
    struct TUserHistoryEntry {
        ui64 Uid = 0;
        time_t ReversedUnixtime = 0;
        TString Operation;
        TString Module;
        NYT::NYson::TYsonString Data;

        bool operator==(const TUserHistoryEntry& o) const {
            return Uid == o.Uid &&
                   ReversedUnixtime == o.ReversedUnixtime &&
                   Operation == o.Operation &&
                   Module == o.Module &&
                   ((!Data && !o.Data) || ((bool)Data && (bool)o.Data && Data == o.Data));
        }
    };

    class TUserHistoryQueryConverter: public NYt::TBaseConverter<TUserHistoryEntry> {
    public:
        NYt::TWriteQuery Convert(
            const TString& table,
            size_t offset,
            size_t count) const override;

        static NYt::TWriteQuery ConvertImpl(const TString& table,
                                            std::span<const TUserHistoryEntry> data);
    };
    using TUserHistoryQueryConverterPtr = std::unique_ptr<TUserHistoryQueryConverter>;

    class TUsersHistory {
    public:
        static const TString TABLE_NAME;
        static const TString CORP_TABLE_NAME;

        static TUserHistoryEntry BuildEntry(const NParser::TMailUserJournalRow& entry,
                                            size_t compressIfMoreThan = 100 * 1024);

        static NYT::NYson::TYsonString BuildData(const NParser::TMailUserJournalRow& entry,
                                                 size_t compressIfMoreThan = 100 * 1024);

        static NYt::TTableSchema CreateYtSchema();
    };
}
