#pragma once

#include "tables_lifetime_config.h"
#include "mail_user_journal/users_history.h"

#include <passport/infra/daemons/lbchdb/src/parsers/mail_user_journal_parser.h>

#include <passport/infra/libs/cpp/yt/periodic_table.h>

#include <map>

namespace NPassport::NLbchdb::NYtConv {
    class TMailUserJournalConverter: TMoveOnly {
    public:
        TMailUserJournalConverter();

        void Reserve(size_t size);
        void Process(const NParser::TMailUserJournalRow& entry, size_t compressIfMoreThan, const TTablesLifeTimeConfig& config);
        NYt::TWriteQueries<TString> Finish();

    private:
        std::map<NYt::TMonthlyTable, NMailUserJournal::TUserHistoryQueryConverterPtr> Corp_;
        std::map<NYt::TMonthlyTable, NMailUserJournal::TUserHistoryQueryConverterPtr> Prod_;
        size_t Reserve_ = 0;

        bool IsFinished_ = false;
    };
}
