#include "entry.h"

#include <passport/infra/daemons/lbchdb/src/yt_converters/utils.h>

#include <yt/yt/core/yson/writer.h>

namespace NPassport::NLbchdb::NYtConv::NPush {
    TEntryBuilder::TEntryBuilder(const NParser::TPushRow& row)
        : Row_(row)
        , Ids_(std::make_shared<TPushIds>(TPushIds{
              .PushId = row.PushId,
              .SubscriptionId = row.SubscriptionId,
              .AppId = row.AppId,
              .DeviceId = row.DeviceId}))
    {
    }

    TPushEntry TEntryBuilder::BuildPushEntry() const {
        return TPushEntry{
            .Uid = Row_.Uid,
            .Unixtime = Row_.Unixtime.Seconds(),
            .Ids = Ids_,
            .Data = BuildData(Row_),
        };
    }

    TPushIndxEntry TEntryBuilder::BuildPushIndxEntry() const {
        return TPushIndxEntry{
            .Uid = Row_.Uid,
            .ReversedUnixtime = TUtils::ReverseTimeT(Row_.Unixtime.Seconds()),
            .Ids = Ids_,
        };
    }

    NYT::NYson::TYsonString TEntryBuilder::BuildData(const NParser::TPushRow& row) {
        TStringStream stream;
        stream.Reserve(1024);

        NYT::NYson::TBufferedBinaryYsonWriter writer(&stream);
        writer.OnBeginMap();

        auto writeIfNotEmpty = [&writer](const TStringBuf key, const TStringBuf value) {
            if (value.empty()) {
                return;
            }

            writer.OnKeyedItem(key);
            writer.OnStringScalar(value);
        };

        writeIfNotEmpty("context", row.Context);
        writeIfNotEmpty("status", row.Status);
        writeIfNotEmpty("push_service", row.PushService);
        writeIfNotEmpty("push_event", row.PushEvent);
        writeIfNotEmpty("details", row.Details);

        writer.OnEndMap();
        writer.Flush();

        return NYT::NYson::TYsonString(stream.Str());
    }
}

using namespace NPassport::NLbchdb::NYtConv::NPush;

template <>
void Out<TPushIds>(IOutputStream& o, const TPushIds& value) {
    o << "push_id=" << value.PushId
      << ". subscription_id=" << value.SubscriptionId
      << ". app_id=" << value.AppId
      << ". device_id=" << value.DeviceId;
}

template <>
void Out<TPushEntry>(IOutputStream& o, const TPushEntry& value) {
    o << "uid=" << value.Uid
      << ". unixtime=" << value.Unixtime
      << ". " << *value.Ids
      << ". data=" << value.Data
      << Endl;
}

template <>
void Out<TPushIndxEntry>(IOutputStream& o, const TPushIndxEntry& value) {
    o << "uid=" << value.Uid
      << ". reversed_unixtime=" << value.ReversedUnixtime
      << ". " << *value.Ids
      << Endl;
}
