#pragma once

#include <passport/infra/daemons/lbchdb/src/parsers/push_parser.h>

#include <yt/yt/core/yson/string.h>

namespace NPassport::NLbchdb::NYtConv::NPush {
    struct TPushIds: TMoveOnly {
        TString PushId;
        TString SubscriptionId;
        TString AppId;
        TString DeviceId;
    };

    struct TPushEntry: TMoveOnly {
        ui64 Uid = 0;
        ui64 Unixtime = 0;

        std::shared_ptr<TPushIds> Ids;

        NYT::NYson::TYsonString Data;
    };

    struct TPushIndxEntry: TMoveOnly {
        ui64 Uid = 0;
        time_t ReversedUnixtime = 0;

        std::shared_ptr<TPushIds> Ids;
    };

    class TEntryBuilder {
    public:
        TEntryBuilder(const NParser::TPushRow& row);

        TPushEntry BuildPushEntry() const;
        TPushIndxEntry BuildPushIndxEntry() const;

    private:
        static NYT::NYson::TYsonString BuildData(const NParser::TPushRow& row);

        const NParser::TPushRow& Row_;
        std::shared_ptr<TPushIds> Ids_;
    };
}
