#include "push.h"

#include <passport/infra/libs/cpp/yt/yt_impl.h>

#include <yt/yt/client/table_client/comparator.h>
#include <yt/yt/client/table_client/helpers.h>
#include <yt/yt/client/table_client/logical_type.h>
#include <yt/yt/client/table_client/name_table.h>

namespace NPassport::NLbchdb::NYtConv::NPush {
    NYt::TWriteQuery TPushQueryConverter::Convert(const TString& table,
                                                  size_t offset,
                                                  size_t count) const {
        return ConvertImpl(table, GetSpan(offset, count));
    }

    static NYT::NTableClient::TNameTablePtr CreateNameTable() {
        NYT::NTableClient::TNameTablePtr res = NYT::New<NYT::NTableClient::TNameTable>();
        res->RegisterName("push_id");
        res->RegisterName("subscription_id");
        res->RegisterName("uid");
        res->RegisterName("device_id");
        res->RegisterName("app_id");
        res->RegisterName("unixtime");
        res->RegisterName("data");
        return res;
    }
    static const NYT::NTableClient::TNameTablePtr NAME_TABLE = CreateNameTable();

    NYt::TWriteQuery TPushQueryConverter::ConvertImpl(const TString& table,
                                                      std::span<const TPushEntry> data) {
        NYt::TWriteQuery res;
        res.Impl = std::make_unique<NYt::TWriteQueryImpl>();
        NYt::TWriteSubQuery& sub = res.Impl->Subqueries.emplace_back();

        sub.Path = table;
        sub.NameTable = NAME_TABLE;

        NYT::NTableClient::TUnversionedRowsBuilder builder;
        builder.ReserveRows(data.size());

        for (const auto& entry : data) {
            builder.AddRow(
                entry.Ids->PushId,
                entry.Ids->SubscriptionId,
                entry.Uid,
                entry.Ids->DeviceId,
                entry.Ids->AppId,
                entry.Unixtime,
                entry.Data);
        }

        sub.Range = builder.Build();

        return res;
    }

    const TString TPushTable::TABLE_NAME = "push";

    NYt::TTableSchema TPushTable::CreateYtSchema() {
        NYt::TTableSchema res;
        res.Impl = std::make_shared<NYt::TTableSchemaImpl>();

        res.Impl->Schema = NYT::NTableClient::TTableSchema(
            std::vector<NYT::NTableClient::TColumnSchema>({
                NYT::NTableClient::TColumnSchema(
                    "push_id",
                    SimpleLogicalType(NYT::NTableClient::ESimpleLogicalValueType::String),
                    NYT::NTableClient::ESortOrder::Ascending),
                NYT::NTableClient::TColumnSchema(
                    "subscription_id",
                    SimpleLogicalType(NYT::NTableClient::ESimpleLogicalValueType::String),
                    NYT::NTableClient::ESortOrder::Ascending),
                NYT::NTableClient::TColumnSchema("uid", NYT::NTableClient::ESimpleLogicalValueType::Uint64),
                NYT::NTableClient::TColumnSchema("device_id", NYT::NTableClient::ESimpleLogicalValueType::String),
                NYT::NTableClient::TColumnSchema("app_id", NYT::NTableClient::ESimpleLogicalValueType::String),
                NYT::NTableClient::TColumnSchema("unixtime", NYT::NTableClient::ESimpleLogicalValueType::Datetime),
                NYT::NTableClient::TColumnSchema("data", NYT::NTableClient::ESimpleLogicalValueType::Any),
            }),
            true,
            true);

        return res;
    }
}
