#pragma once

#include "entry.h"

#include <passport/infra/libs/cpp/yt/query.h>

namespace NPassport::NLbchdb::NYtConv::NPush {
    class TPushQueryConverter: public NYt::TBaseConverter<TPushEntry> {
    public:
        NYt::TWriteQuery Convert(
            const TString& table,
            size_t offset,
            size_t count) const override;

        static NYt::TWriteQuery ConvertImpl(const TString& table,
                                            std::span<const TPushEntry> data);
    };
    using TPushQueryConverterPtr = std::unique_ptr<TPushQueryConverter>;

    class TPushTable {
    public:
        static const TString TABLE_NAME;

        static NYt::TTableSchema CreateYtSchema();
    };
}
