#include "push_by_app_id.h"

#include <passport/infra/libs/cpp/yt/yt_impl.h>

#include <yt/yt/client/table_client/comparator.h>
#include <yt/yt/client/table_client/helpers.h>
#include <yt/yt/client/table_client/logical_type.h>
#include <yt/yt/client/table_client/name_table.h>

namespace NPassport::NLbchdb::NYtConv::NPush {
    NYt::TWriteQuery TPushByAppIdQueryConverter::Convert(const TString& table,
                                                         size_t offset,
                                                         size_t count) const {
        return ConvertImpl(table, GetSpan(offset, count));
    }

    static NYT::NTableClient::TNameTablePtr CreateNameTable() {
        NYT::NTableClient::TNameTablePtr res = NYT::New<NYT::NTableClient::TNameTable>();
        res->RegisterName("uid");
        res->RegisterName("app_id");
        res->RegisterName("reversed_timestamp");
        res->RegisterName("push_id");
        res->RegisterName("subscription_id");
        res->RegisterName("dummy");
        return res;
    }
    static const NYT::NTableClient::TNameTablePtr NAME_TABLE = CreateNameTable();

    NYt::TWriteQuery TPushByAppIdQueryConverter::ConvertImpl(const TString& table,
                                                             std::span<const TPushIndxEntry> data) {
        NYt::TWriteQuery res;
        res.Impl = std::make_unique<NYt::TWriteQueryImpl>();
        NYt::TWriteSubQuery& sub = res.Impl->Subqueries.emplace_back();

        sub.Path = table;
        sub.NameTable = NAME_TABLE;

        NYT::NTableClient::TUnversionedRowsBuilder builder;
        builder.ReserveRows(data.size());

        for (const auto& entry : data) {
            builder.AddRow(
                entry.Uid,
                entry.Ids->AppId,
                entry.ReversedUnixtime,
                entry.Ids->PushId,
                entry.Ids->SubscriptionId,
                std::nullopt);
        }

        sub.Range = builder.Build();

        return res;
    }

    const TString TPushByAppIdTable::TABLE_NAME = "push-by-app-id";

    NYt::TTableSchema TPushByAppIdTable::CreateYtSchema() {
        NYt::TTableSchema res;
        res.Impl = std::make_shared<NYt::TTableSchemaImpl>();

        res.Impl->Schema = NYT::NTableClient::TTableSchema(
            std::vector<NYT::NTableClient::TColumnSchema>({
                NYT::NTableClient::TColumnSchema(
                    "uid",
                    SimpleLogicalType(NYT::NTableClient::ESimpleLogicalValueType::Uint64),
                    NYT::NTableClient::ESortOrder::Ascending),
                NYT::NTableClient::TColumnSchema(
                    "app_id",
                    SimpleLogicalType(NYT::NTableClient::ESimpleLogicalValueType::String),
                    NYT::NTableClient::ESortOrder::Ascending),
                NYT::NTableClient::TColumnSchema(
                    "reversed_timestamp",
                    SimpleLogicalType(NYT::NTableClient::ESimpleLogicalValueType::Int64),
                    NYT::NTableClient::ESortOrder::Ascending),
                NYT::NTableClient::TColumnSchema(
                    "push_id",
                    SimpleLogicalType(NYT::NTableClient::ESimpleLogicalValueType::String),
                    NYT::NTableClient::ESortOrder::Ascending),
                NYT::NTableClient::TColumnSchema(
                    "subscription_id",
                    SimpleLogicalType(NYT::NTableClient::ESimpleLogicalValueType::String),
                    NYT::NTableClient::ESortOrder::Ascending),
                NYT::NTableClient::TColumnSchema("dummy", NYT::NTableClient::ESimpleLogicalValueType::Any),
            }),
            true,
            true);

        return res;
    }
}
