#pragma once

#include "entry.h"

#include <passport/infra/libs/cpp/yt/query.h>

namespace NPassport::NLbchdb::NYtConv::NPush {
    class TPushByUidQueryConverter: public NYt::TBaseConverter<TPushIndxEntry> {
    public:
        NYt::TWriteQuery Convert(
            const TString& table,
            size_t offset,
            size_t count) const override;

        static NYt::TWriteQuery ConvertImpl(const TString& table,
                                            std::span<const TPushIndxEntry> data);
    };
    using TPushByUidQueryConverterPtr = std::unique_ptr<TPushByUidQueryConverter>;

    class TPushByUidTable {
    public:
        static const TString TABLE_NAME;

        static NYt::TTableSchema CreateYtSchema();
    };
}
