#pragma once

#include "tables_lifetime_config.h"
#include "push/push.h"
#include "push/push_by_app_id.h"
#include "push/push_by_device_id.h"
#include "push/push_by_uid.h"

#include <passport/infra/libs/cpp/yt/periodic_table.h>

#include <map>

namespace NPassport::NLbchdb::NYtConv {
    class TPushConverter: TMoveOnly {
    public:
        TPushConverter();

        void Reserve(size_t size);
        void Process(const NParser::TPushRow& row, const TTablesLifeTimeConfig& config);
        NYt::TWriteQueries<TString> Finish();

    private:
        struct TQueryConverters {
            void Init(size_t reserve);

            NPush::TPushQueryConverterPtr Push;
            NPush::TPushByUidQueryConverterPtr PushByUid;
            NPush::TPushByDeviceIdQueryConverterPtr PushByDeviceId;
            NPush::TPushByAppIdQueryConverterPtr PushByAppId;
        };

        std::map<NYt::TMonthlyTable, TQueryConverters> Tables_;
        size_t Reserve_ = 0;

        bool IsFinished_ = false;
    };
}
