#include "push_subscription.h"

#include <passport/infra/libs/cpp/yt/yt_impl.h>

#include <yt/yt/client/table_client/helpers.h>
#include <yt/yt/client/table_client/name_table.h>
#include <yt/yt/client/table_client/row_buffer.h>

namespace NPassport::NLbchdb::NYtConv::NPushSubscription {
    const TString TPushSubscriptionQueryConverter::TABLE_NAME = "push_subscription/push_subscription";

    NYt::TWriteQuery TPushSubscriptionQueryConverter::Convert(const TString& table,
                                                              size_t offset,
                                                              size_t count) const {
        return ConvertImpl(table, GetSpan(offset, count));
    }

    static NYT::NTableClient::TNameTablePtr CreateNameTable() {
        NYT::NTableClient::TNameTablePtr res = NYT::New<NYT::NTableClient::TNameTable>();
        res->RegisterName("uid");
        res->RegisterName("app_id");
        res->RegisterName("device_id");
        res->RegisterName("timestamp");
        res->RegisterName("count");
        return res;
    }
    static const NYT::NTableClient::TNameTablePtr NAME_TABLE = CreateNameTable();

    NYt::TWriteQuery TPushSubscriptionQueryConverter::ConvertImpl(
        const TString& table,
        std::span<const TPushSubscriptionEntry> data)
    {
        NYt::TWriteQuery res;

        res.Impl = std::make_unique<NYt::TWriteQueryImpl>();
        NYt::TWriteSubQuery& sub = res.Impl->Subqueries.emplace_back();

        sub.Path = table;
        sub.NameTable = NAME_TABLE;

        sub.RowBuffer = NYT::New<NYT::NTableClient::TRowBuffer>();
        std::vector<NYT::NTableClient::TUnversionedRow> vecRows;
        vecRows.reserve(data.size());

        for (const TPushSubscriptionEntry& d : data) {
            int colIdx = 0;
            NYT::NTableClient::TUnversionedRowBuilder builder;

            auto addValue = [&builder, &colIdx, &sub](const auto& val, bool aggregate) {
                using namespace NYT::NTableClient;
                auto flags = aggregate ? EValueFlags::Aggregate : EValueFlags::None;

                NYT::NTableClient::TUnversionedValue unversionedValue{};
                NYT::NTableClient::ToUnversionedValue(&unversionedValue, val, sub.RowBuffer, colIdx++, flags);
                builder.AddValue(unversionedValue);
            };

            addValue(d.Row.Uid, false);
            addValue(d.Row.AppId, false);
            addValue(d.Row.DeviceId, false);
            addValue(d.Row.Unixtime.Seconds(), false);
            addValue(d.Count, true);

            vecRows.push_back(sub.RowBuffer->CaptureRow(builder.GetRow()));
        }

        res.Size = sub.RowBuffer->GetSize();
        sub.Range = MakeSharedRange(std::move(vecRows), sub.RowBuffer);

        return res;
    }
}

using namespace NPassport::NLbchdb::NYtConv::NPushSubscription;

template <>
void Out<TPushSubscriptionEntry>(IOutputStream& o, const TPushSubscriptionEntry& value) {
    o << "uid=" << value.Row.Uid
      << ". app_id=" << value.Row.AppId
      << ". device_id=" << value.Row.DeviceId
      << ". ts=" << value.Row.Unixtime
      << ". count=" << value.Count
      << Endl;
}
