#pragma once

#include <passport/infra/daemons/lbchdb/src/parsers/push_subscription_parser.h>

#include <passport/infra/libs/cpp/yt/query.h>

namespace NPassport::NLbchdb::NYtConv::NPushSubscription {
    struct TPushSubscriptionEntry {
        NParser::TPushSubscriptionRow Row;
        size_t Count = 0;
    };

    class TPushSubscriptionQueryConverter
        : public NYt::TBaseConverter<TPushSubscriptionEntry> {
    public:
        static const TString TABLE_NAME;

        NYt::TWriteQuery Convert(
            const TString& table,
            size_t offset,
            size_t count) const override;

    private:
        static NYt::TWriteQuery ConvertImpl(
            const TString& table,
            std::span<const TPushSubscriptionEntry> data);
    };
    using TPushSubscriptionQueryConverterPtr = std::unique_ptr<TPushSubscriptionQueryConverter>;
}
