#include "push_subscription_converter.h"

#include "push_subscription/push_subscription.h"

namespace NPassport::NLbchdb::NYtConv {
    void TPushSubscriptionConverter::Reserve(size_t size) {
        RowsWithCounters_.reserve(size);
    }

    void TPushSubscriptionConverter::Process(const NParser::TPushSubscriptionRow& row, TDuration bucketWidth) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        NParser::TPushSubscriptionRow normalized = row;
        if (bucketWidth) {
            normalized.Unixtime -= TDuration::Seconds(normalized.Unixtime.Seconds() % bucketWidth.Seconds());
        }

        auto [it, ok] = RowsWithCounters_.emplace(std::move(normalized), 0);
        ++it->second;
    }

    NYt::TWriteQueries<TString> TPushSubscriptionConverter::Finish() {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        IsFinished_ = true;

        std::unique_ptr conv = std::make_unique<NPushSubscription::TPushSubscriptionQueryConverter>();
        for (const auto& [row, count] : RowsWithCounters_) {
            conv->Add(NPushSubscription::TPushSubscriptionEntry{
                .Row = row,
                .Count = count,
            });
        }

        NYt::TWriteQueries<TString> res;

        res.ByTable.emplace(
            NPushSubscription::TPushSubscriptionQueryConverter::TABLE_NAME,
            std::move(conv));

        return res;
    }

    const TPushSubscriptionConverter::TRowsWithCounters& TPushSubscriptionConverter::GetRows() const {
        return RowsWithCounters_;
    }
}
