#pragma once

#include <passport/infra/daemons/lbchdb/src/parsers/push_subscription_parser.h>

namespace NPassport::NLbchdb::NYtConv {
    class TPushSubscriptionConverter: TMoveOnly {
    public:
        using TRowsWithCounters = THashMap<NParser::TPushSubscriptionRow, size_t>;

        void Reserve(size_t size);
        void Process(const NParser::TPushSubscriptionRow& row, TDuration bucketWidth);
        NYt::TWriteQueries<TString> Finish();

        // for tests
        const TRowsWithCounters& GetRows() const;

    private:
        TRowsWithCounters RowsWithCounters_;

        bool IsFinished_ = false;
    };
}
