#pragma once

#include <passport/infra/daemons/lbchdb/src/parsers/restore_parser.h>

#include <passport/infra/libs/cpp/yt/query.h>

#include <yt/yt/core/yson/string.h>

namespace NPassport::NLbchdb::NCrypto {
    class TEncryptor;
}

namespace NPassport::NLbchdb::NYtConv::NRestore {
    struct TRestoreEntry: TMoveOnly {
        static TRestoreEntry BuildFrom(
            const NParser::TRestoreRow& row,
            const NCrypto::TEncryptor& encryptor,
            size_t compressIfMoreThan = 100 * 1024);

        ui64 Uid = 0;
        time_t ReversedTimestamp = 0;
        NYT::NYson::TYsonString Data;
    };

    class TRestoreQueryConverter: public NYt::TBaseConverter<TRestoreEntry> {
    public:
        NYt::TWriteQuery Convert(
            const TString& table,
            size_t offset,
            size_t count) const override;

        static NYt::TWriteQuery ConvertImpl(
            const TString& table,
            std::span<const TRestoreEntry> data);
    };
    using TRestoreQueryConverterPtr = std::unique_ptr<TRestoreQueryConverter>;

    class TRestore {
    public:
        static const TString TABLE_NAME;
    };
}
