#include "restore_converter.h"

namespace NPassport::NLbchdb::NYtConv {
    TRestoreConverter::TRestoreConverter()
        : Converter_(std::make_unique<NRestore::TRestoreQueryConverter>())
    {
    }

    TRestoreConverter::~TRestoreConverter() = default;

    void TRestoreConverter::Reserve(size_t size) {
        Converter_->Reserve(size);
    }

    void TRestoreConverter::Process(const NParser::TRestoreRow& entry, const NCrypto::TEncryptor& encryptor, size_t compressIfMoreThan) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        Converter_->Add(NRestore::TRestoreEntry::BuildFrom(entry, encryptor, compressIfMoreThan));
    }

    NYt::TWriteQueries<TString> TRestoreConverter::Finish() {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        IsFinished_ = true;

        NYt::TWriteQueries<TString> res;

        res.ByTable.emplace(
            NRestore::TRestore::TABLE_NAME,
            std::move(Converter_));

        return res;
    }
}
