#include "last_letter.h"

#include <passport/infra/libs/cpp/yt/yt_impl.h>

#include <yt/yt/client/table_client/helpers.h>
#include <yt/yt/client/table_client/name_table.h>
#include <yt/yt/client/table_client/row_buffer.h>

namespace NPassport::NLbchdb::NYtConv::NSenderLastLetter {
    const TString TLastLetter::TABLE_NAME = "sendr/last_letter";

    NYt::TWriteQuery TLastLetterQueryConverter::Convert(const TString& table,
                                                        size_t offset,
                                                        size_t count) const {
        return ConvertImpl(table, GetSpan(offset, count));
    }

    static NYT::NTableClient::TNameTablePtr CreateNameTable() {
        NYT::NTableClient::TNameTablePtr res = NYT::New<NYT::NTableClient::TNameTable>();
        res->RegisterName("uid");
        res->RegisterName("unsibscribe_list");
        res->RegisterName("timestamp");
        return res;
    }
    static const NYT::NTableClient::TNameTablePtr NAME_TABLE = CreateNameTable();

    NYt::TWriteQuery TLastLetterQueryConverter::ConvertImpl(
        const TString& table,
        std::span<const NExtend::TSenderDeliveryExtendedEntry> data) {
        NYt::TWriteQuery res;

        res.Impl = std::make_unique<NYt::TWriteQueryImpl>();
        NYt::TWriteSubQuery& sub = res.Impl->Subqueries.emplace_back();

        sub.Path = table;
        sub.NameTable = NAME_TABLE;

        sub.RowBuffer = NYT::New<NYT::NTableClient::TRowBuffer>();
        std::vector<NYT::NTableClient::TUnversionedRow> vecRows;
        vecRows.reserve(data.size());

        for (const NExtend::TSenderDeliveryExtendedEntry& d : data) {
            int colIdx = 0;
            NYT::NTableClient::TUnversionedRowBuilder builder;

            auto addValue = [&builder, &colIdx](ui64 val, bool aggregate) {
                using namespace NYT::NTableClient;
                auto flags = aggregate ? EValueFlags::Aggregate : EValueFlags::None;
                builder.AddValue(MakeUint64Value<TUnversionedValue>(val, colIdx++, flags));
            };

            addValue(d.Uid, false);
            addValue(d.UnsubscribeList, false);
            addValue(d.Ts, true);

            vecRows.push_back(sub.RowBuffer->CaptureRow(builder.GetRow()));
        }

        res.Size = sub.RowBuffer->GetSize();
        sub.Range = MakeSharedRange(std::move(vecRows), sub.RowBuffer);

        return res;
    }
}

using namespace NPassport::NLbchdb::NExtend;

template <>
void Out<TSenderDeliveryExtendedEntry>(IOutputStream& o, const TSenderDeliveryExtendedEntry& value) {
    o << "uid=" << value.Uid
      << ". unsubscribe_list=" << value.UnsubscribeList
      << ". ts=" << value.Ts
      << Endl;
}
