#include "sender_delivery_converter.h"

#include "sender_delivery/last_letter.h"

namespace NPassport::NLbchdb::NYtConv {
    TSenderDeliveryConverter::TSenderDeliveryConverter()
        : Converter_(std::make_unique<NSenderLastLetter::TLastLetterQueryConverter>())
    {
    }

    TSenderDeliveryConverter::~TSenderDeliveryConverter() = default;

    void TSenderDeliveryConverter::Reserve(size_t size) {
        Converter_->Reserve(size);
    }

    void TSenderDeliveryConverter::Process(NExtend::TSenderDeliveryExtendedEntry&& entry) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        // NOLINTNEXTLINE(performance-move-const-arg)
        Converter_->Add(std::move(entry));
    }

    NYt::TWriteQueries<TString> TSenderDeliveryConverter::Finish() {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        IsFinished_ = true;

        NYt::TWriteQueries<TString> res;

        res.ByTable.emplace(
            NSenderLastLetter::TLastLetter::TABLE_NAME,
            std::move(Converter_));

        return res;
    }
}
