#include "entry.h"

#include <passport/infra/daemons/lbchdb/src/yt_converters/common.h>
#include <passport/infra/daemons/lbchdb/src/yt_converters/utils.h>

#include <yt/yt/core/yson/writer.h>

namespace NPassport::NLbchdb::NYtConv::NYasmsPrivate {
    static NYT::NYson::TYsonString BuildData(const NParser::TYasmsPrivateRow& row,
                                             const NCrypto::TEncryptor& encryptor) {
        TStringStream stream;
        stream.Reserve(1024);

        NYT::NYson::TBufferedBinaryYsonWriter writer(&stream);
        writer.OnBeginMap();

        writer.OnKeyedItem("extra");
        writer.OnBeginMap();

        for (const auto& [key, value] : row.ExtraFields()) {
            if (value.empty() || value == "-") {
                continue;
            }

            writer.OnKeyedItem(key);
            writer.OnStringScalar(value);
        }

        writer.OnEndMap();

        if (row.Text) {
            writer.OnKeyedItem("encrypted_text");
            TYsonSerializer::SerializeEncrypted(writer, row.Text, encryptor, NCrypto::TEncryptor::EKeyRing::YasmsPrivate);
        }

        writer.OnEndMap();
        writer.Flush();

        return NYT::NYson::TYsonString(stream.Str());
    }

    TSmsHistoryEntry TSmsHistoryEntry::Build(const NParser::TYasmsPrivateRow& row,
                                             const NCrypto::TEncryptor& encryptor) {
        return TSmsHistoryEntry{
            .GlobalSmsId = TString(row.GlobalSmsId),
            .Action = TString(row.Action),
            .Phone = row.Phone,
            .Uid = row.Uid ? row.Uid : std::optional<ui64>{},
            .Unixtime = (time_t)row.Timestamp.MicroSeconds(),
            .ReversedUnixtime = TUtils::ReverseTimeT(row.Timestamp.MicroSeconds()),
            .Data = BuildData(row, encryptor),
        };
    }
}

using namespace NPassport::NLbchdb::NYtConv::NYasmsPrivate;

template <>
void Out<TSmsHistoryEntry>(IOutputStream& o, const TSmsHistoryEntry&) {
    o << "TSmsHistoryEntry" << Endl;
}
