#include "sms_history.h"

#include <passport/infra/libs/cpp/yt/helpers.h>
#include <passport/infra/libs/cpp/yt/yt_impl.h>

#include <yt/yt/client/table_client/helpers.h>

namespace NPassport::NLbchdb::NYtConv::NYasmsPrivate {
    const TString TSmsHistoryTable::TABLES_SUB_DIR = "yasms/";

    const TString TSmsHistoryTable::MAIN_TABLE_NAME = "sms_history/sms_history";
    const TString TSmsHistoryTable::BY_PHONE_TABLE_NAME = "sms_history_by_phone/sms_history_by_phone";
    const TString TSmsHistoryTable::BY_UID_TABLE_NAME = "sms_history_by_uid/sms_history_by_uid";

    NYt::TWriteQuery TSmsHistoryQueryConverter::Convert(const TString& table, size_t offset, size_t count) const {
        return ConvertImpl(table, GetSpan(offset, count));
    }

    static const NYT::NTableClient::TNameTablePtr MAIN_NAME_TABLE =
        NYt::THelpers::CreateBasicNameTable({"global_sms_id", "action", "unixtime", "uid", "phone", "data"});

    static const NYT::NTableClient::TNameTablePtr BY_PHONE_NAME_TABLE =
        NYt::THelpers::CreateBasicNameTable({"phone", "reversed_timestamp", "global_sms_id", "action", "dummy"});

    static const NYT::NTableClient::TNameTablePtr BY_UID_NAME_TABLE =
        NYt::THelpers::CreateBasicNameTable({"uid", "reversed_timestamp", "global_sms_id", "action", "dummy"});

    NYt::TWriteQuery TSmsHistoryQueryConverter::ConvertImpl(const TString& table, std::span<const TSmsHistoryEntry> data) {
        NYt::TWriteQuery res;
        res.Impl = std::make_unique<NYt::TWriteQueryImpl>();

        NYT::NTableClient::TUnversionedRowsBuilder mainBuilder;
        mainBuilder.ReserveRows(data.size());

        NYT::NTableClient::TUnversionedRowsBuilder byPhoneBuilder;
        byPhoneBuilder.ReserveRows(data.size());

        NYT::NTableClient::TUnversionedRowsBuilder byUidBuilder;
        byUidBuilder.ReserveRows(data.size());

        for (const auto& entry : data) {
            mainBuilder.AddRow(entry.GlobalSmsId, entry.Action, entry.Unixtime, entry.Uid, entry.Phone, entry.Data);
            byPhoneBuilder.AddRow(entry.Phone, entry.ReversedUnixtime, entry.GlobalSmsId, entry.Action, std::nullopt);
            if (entry.Uid) {
                byUidBuilder.AddRow(*entry.Uid, entry.ReversedUnixtime, entry.GlobalSmsId, entry.Action, std::nullopt);
            }
        }

        res.Impl->Subqueries.emplace_back(NYt::TWriteSubQuery{
            .Path = NUtils::CreateStr(table, TSmsHistoryTable::MAIN_TABLE_NAME),
            .NameTable = MAIN_NAME_TABLE,
            .Range = mainBuilder.Build(),
        });

        res.Impl->Subqueries.emplace_back(NYt::TWriteSubQuery{
            .Path = NUtils::CreateStr(table, TSmsHistoryTable::BY_PHONE_TABLE_NAME),
            .NameTable = BY_PHONE_NAME_TABLE,
            .Range = byPhoneBuilder.Build(),
        });

        res.Impl->Subqueries.emplace_back(NYt::TWriteSubQuery{
            .Path = NUtils::CreateStr(table, TSmsHistoryTable::BY_UID_TABLE_NAME),
            .NameTable = BY_UID_NAME_TABLE,
            .Range = byUidBuilder.Build(),
        });

        return res;
    }
}
