#pragma once

#include "entry.h"

#include <passport/infra/libs/cpp/yt/query.h>

namespace NPassport::NLbchdb::NYtConv::NYasmsPrivate {
    class TSmsHistoryTable {
    public:
        static const TString TABLES_SUB_DIR;

        static const TString MAIN_TABLE_NAME;
        static const TString BY_PHONE_TABLE_NAME;
        static const TString BY_UID_TABLE_NAME;
    };

    class TSmsHistoryQueryConverter: public NYt::TBaseConverter<TSmsHistoryEntry> {
    public:
        NYt::TWriteQuery Convert(const TString& table, size_t offset, size_t count) const override;

    private:
        static NYt::TWriteQuery ConvertImpl(const TString& table, std::span<const TSmsHistoryEntry> data);
    };
    using TSmsHistoryQueryConverterPtr = std::unique_ptr<TSmsHistoryQueryConverter>;
}
