#include "yasms_private_converter.h"

namespace NPassport::NLbchdb::NYtConv {
    TYasmsPrivateConverter::TYasmsPrivateConverter(const NCrypto::TEncryptor& encryptor)
        : Encryptor_(encryptor)
        , Converter_(std::make_unique<NYasmsPrivate::TSmsHistoryQueryConverter>())
    {
    }

    void TYasmsPrivateConverter::Reserve(size_t size) {
        Converter_->Reserve(size);
    }

    void TYasmsPrivateConverter::Process(const NParser::TYasmsPrivateRow& row) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        Converter_->Add(NYasmsPrivate::TSmsHistoryEntry::Build(row, Encryptor_));
    }

    NYt::TWriteQueries<TString> TYasmsPrivateConverter::Finish() {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        IsFinished_ = true;

        NYt::TWriteQueries<TString> res;
        res.ByTable.emplace(NYasmsPrivate::TSmsHistoryTable::TABLES_SUB_DIR, std::move(Converter_));

        return res;
    }
}
