#include <passport/infra/daemons/lbchdb/src/blackbox_client.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;

Y_UNIT_TEST_SUITE(BlackboxClient) {
    Y_UNIT_TEST(createUserinfoRequest) {
        UNIT_ASSERT_VALUES_EQUAL(
            TBlackboxClient::TRequest({
                .Path = "/blackbox",
                .Body = "method=userinfo&format=json&userip=127.0.0.1&sid=smtp&login=vasya+%D0%BB%D1%8E%D0%B1%D0%B8%D1%82%40%D0%BC%D0%B0%D0%BC%D1%83.ru",
            }),
            TBlackboxClient::CreateUserinfoRequest("vasya любит@маму.ru"));
        UNIT_ASSERT_VALUES_EQUAL(
            TBlackboxClient::TRequest({
                .Path = "/kajsdnaksjdn",
                .Body = "method=userinfo&format=json&userip=127.0.0.1&sid=smtp&login=vasya%40yandex.ru",
            }),
            TBlackboxClient::CreateUserinfoRequest("vasya@yandex.ru", "/kajsdnaksjdn"));
    }

    Y_UNIT_TEST(createEmailBindingsRequest) {
        UNIT_ASSERT_VALUES_EQUAL(
            TBlackboxClient::TRequest({
                .Path = "/blackbox",
                .Body = "method=email_bindings&format=json&email=vasya+%D0%BB%D1%8E%D0%B1%D0%B8%D1%82%40xn--80axb2a.ru",
            }),
            TBlackboxClient::CreateEmailBindingsRequest("vasya любит@маму.ru"));
        UNIT_ASSERT_VALUES_EQUAL(
            TBlackboxClient::TRequest({
                .Path = "/kajsdnaksjdn",
                .Body = "method=email_bindings&format=json&email=vasya+%D0%BB%D1%8E%D0%B1%D0%B8%D1%82%40xn--80axb2a.ru",
            }),
            TBlackboxClient::CreateEmailBindingsRequest("vasya любит@маму.ru", "/kajsdnaksjdn"));
        UNIT_ASSERT_VALUES_EQUAL(
            TBlackboxClient::TRequest({
                .Path = "/blackbox",
                .Body = "method=email_bindings&format=json&email=vasya%40yandex.ru",
            }),
            TBlackboxClient::CreateEmailBindingsRequest("vasya@yandex.ru"));
    }

    Y_UNIT_TEST(parseResponseForUserinfo) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBlackboxClient::ParseResponseForUserinfo("{"),
            TBlackboxClient::TParseException,
            "malformed json from blackbox");
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBlackboxClient::ParseResponseForUserinfo(R"(
{
  "exception": {
    "value": "INVALID_PARAMS",
    "id": 2
  },
  "error": "aaaaaaaaaaaaaaaaaaaaaaaaaaa"
})"),
            TBlackboxClient::TParseException,
            "blackbox exception (INVALID_PARAMS): aaaaaaaaaaaaaaaaaaaaaaaaaaa");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBlackboxClient::ParseResponseForUserinfo(R"(
{
  "users": [{"uid": {"value": 17145248}}]
})"),
            TBlackboxClient::TParseException,
            "uid is not string");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBlackboxClient::ParseResponseForUserinfo(R"(
{
  "users": [{"uid": {"value": "qwerty"}}]
})"),
            TBlackboxClient::TParseException,
            "failed to parse uid: 'qwerty'");

        UNIT_ASSERT(!TBlackboxClient::ParseResponseForUserinfo(R"(
{
  "users": [{
    "id": "",
    "uid": {},
    "karma": {"value": 0},
    "karma_status": {"value": 0}
  }]
})"));

        std::optional res = TBlackboxClient::ParseResponseForUserinfo(R"(
{
  "users": [{
      "id": "17145248",
      "uid": {
        "value": "17145248",
        "lite": false,
        "hosted": false
      },
      "login": "asdzxcq",
      "have_password": true,
      "have_hint": true,
      "karma": {"value": 0},
      "karma_status": {"value": 0}
  }]
})");
        UNIT_ASSERT(res);
        UNIT_ASSERT_VALUES_EQUAL(*res, 17145248);
    }

    Y_UNIT_TEST(parseResponseForEmailBindings) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBlackboxClient::ParseResponseForEmailBindings("{"),
            TBlackboxClient::TParseException,
            "malformed json from blackbox");
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBlackboxClient::ParseResponseForEmailBindings(R"(
{
  "exception": {
    "value": "INVALID_PARAMS",
    "id": 2
  },
  "error": "aaaaaaaaaaaaaaaaaaaaaaaaaaa"
})"),
            TBlackboxClient::TParseException,
            "blackbox exception (INVALID_PARAMS): aaaaaaaaaaaaaaaaaaaaaaaaaaa");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBlackboxClient::ParseResponseForEmailBindings(R"({})"),
            TBlackboxClient::TParseException,
            "missing uid array");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBlackboxClient::ParseResponseForEmailBindings(R"(
{
  "count": "1",
  "total_count": "1",
  "uids": [
    71001
  ]
})"),
            TBlackboxClient::TParseException,
            "uid is not string");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBlackboxClient::ParseResponseForEmailBindings(R"(
{
  "count": "1",
  "total_count": "1",
  "uids": [
    "qwerty"
  ]
})"),
            TBlackboxClient::TParseException,
            "failed to parse uid: 'qwerty'");

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<ui64>(),
            TBlackboxClient::ParseResponseForEmailBindings(R"(
{
  "count": "0",
  "total_count": "0",
  "uids": []
})"));

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<ui64>({71001, 71002, 71003}),
            TBlackboxClient::ParseResponseForEmailBindings(R"(
{
  "count": "1",
  "total_count": "1",
  "uids": [
    "71001",
    "71002",
    "71003"
  ]
})"));
    }
}

template <>
void Out<std::vector<ui64>>(IOutputStream& o, const std::vector<ui64>& value) {
    for (ui64 i : value) {
        o << i << ",";
    }
}
