#include "common.h"

#include <yt/yt/core/yson/writer.h>

namespace NPassport::NLbchdb {
    NYT::NYson::TYsonString ToYson(const std::vector<std::pair<TString, TString>>& data) {
        TStringStream stream;
        NYT::NYson::TBufferedBinaryYsonWriter writer(&stream);
        writer.OnBeginMap();

        for (const auto& [key, value] : data) {
            writer.OnKeyedItem(key);
            writer.OnStringScalar(value);
        }

        writer.OnEndMap();
        writer.Flush();

        return NYT::NYson::TYsonString(stream.Str());
    }
}
