#pragma once

#include <passport/infra/daemons/lbchdb/src/depends/ipreg.h>
#include <passport/infra/daemons/lbchdb/src/depends/uatraits.h>
#include <passport/infra/daemons/lbchdb/src/parsers/event_parser.h>

#include <passport/infra/libs/cpp/geobase/geobase.h>

#include <yt/yt/core/yson/string.h>

#include <util/stream/output.h>
#include <util/system/env.h>

#include <string>
#include <time.h>

inline void SetTimeZone() {
    SetEnv("TZ", "Europe/Moscow");
    tzset();
}

namespace NPassport::NLbchdb {
    NYT::NYson::TYsonString ToYson(const std::vector<std::pair<TString, TString>>& data);

    class TTestGeobase: public NGeobase::IGeobase {
    public:
        std::optional<ui32> GetRegionId(const std::string&) const override {
            return RegionId;
        }

        std::optional<std::string> GetAs(const std::string&) const override {
            return As;
        }

    public:
        std::optional<ui32> RegionId;
        std::optional<std::string> As;
    };

    class TTestIpReg: public IIpReg {
    public:
        TIpInfo GetIpInfo(const TString&) const override {
            return Info;
        }

    public:
        TIpInfo Info;
    };

    class TTestUaTraits: public IUaTraits {
    public:
        std::optional<TData> GetUaData(const TString&) const override {
            return Data;
        }

    public:
        std::optional<TData> Data;
    };
}
