#include <passport/infra/daemons/lbchdb/ut/common.h>

#include <passport/infra/daemons/lbchdb/src/hbase_converters/aggregate_auth_helper.h>
#include <passport/infra/daemons/lbchdb/src/proto/auths.pb.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NHBaseConv;

Y_UNIT_TEST_SUITE(ConvertAggregateAuthHelper) {
    Y_UNIT_TEST(isEntryWriteable) {
        std::optional<NExtend::TIpData> ip;

        UNIT_ASSERT(!TAggregateAuthHelper::IsEntryWriteable(ip));

        ip = NExtend::TIpData{};
        UNIT_ASSERT(!TAggregateAuthHelper::IsEntryWriteable(ip));

        ip = NExtend::TIpData{
            .Packed = "123",
        };
        UNIT_ASSERT(!TAggregateAuthHelper::IsEntryWriteable(ip));

        ip = NExtend::TIpData{
            .Packed = "123",
            .Unpacked = "456",
        };
        UNIT_ASSERT(!TAggregateAuthHelper::IsEntryWriteable(ip));

        ip = NExtend::TIpData{
            .Packed = "123",
            .Unpacked = "456",
            .IsReal = true,
        };
        UNIT_ASSERT(TAggregateAuthHelper::IsEntryWriteable(ip));

        ip = NExtend::TIpData{
            .Packed = "123",
            .Unpacked = "456",
            .IsReal = true,
            .IsYandex = true,
        };
        UNIT_ASSERT(!TAggregateAuthHelper::IsEntryWriteable(ip));

        ip = NExtend::TIpData{
            .Packed = "123",
            .IsReal = true,
        };
        UNIT_ASSERT(!TAggregateAuthHelper::IsEntryWriteable(ip));
    }

    Y_UNIT_TEST(fillIpInfo) {
        AuthInfo proto;

        NExtend::TIpData ip;
        TAggregateAuthHelper::FillIpInfo(ip, proto);
        UNIT_ASSERT_VALUES_EQUAL(proto.DebugString(),
                                 "ip_info {\n  ip: \"\"\n}\n");

        ip = NExtend::TIpData{
            .GeoId = 42,
            .As = "123456",
            .Packed = "123",
        };
        proto = AuthInfo();
        TAggregateAuthHelper::FillIpInfo(ip, proto);
        UNIT_ASSERT_VALUES_EQUAL(proto.DebugString(),
                                 "ip_info {\n  ip: \"123\"\n  geoId: 42\n  AS: 3456\n}\n");

        ip = NExtend::TIpData{
            .GeoId = 42,
            .As = "qwerty",
            .Packed = "123",
        };
        proto = AuthInfo();
        TAggregateAuthHelper::FillIpInfo(ip, proto);
        UNIT_ASSERT_VALUES_EQUAL(proto.DebugString(),
                                 "ip_info {\n  ip: \"123\"\n  geoId: 42\n}\n");
    }

    Y_UNIT_TEST(buildRow) {
        UNIT_ASSERT_VALUES_EQUAL(
            NUtils::Bin2hex(
                TAggregateAuthHelper::BuildRow(
                    789,
                    TInstant::ParseIso8601("2010-03-16T11:02:55.123456+03"))),
            "3738390000000000000315fffa9f57");
    }
}
