#include <passport/infra/daemons/lbchdb/src/hbase_converters/auth/failed_auths.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NHBaseConv::NAuth;

Y_UNIT_TEST_SUITE(ConvertBbAuthFailedAuths) {
    Y_UNIT_TEST(buildRow) {
        NExtend::TAuthExtendedEntry entry;
        entry.Row.Timestamp = TInstant::ParseIso8601("2010-03-16T11:02:55.123456+03");
        entry.Row.Uid = 789;
        entry.Row.HostId = 127;

        UNIT_ASSERT_VALUES_EQUAL(TFailedAuthQuery::BuildRow(entry, false),
                                 "789_9223372035586049232.876544_127");
    }
}
