#include <passport/infra/daemons/lbchdb/src/hbase_converters/auth/last_auth.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NHBaseConv::NAuth;

Y_UNIT_TEST_SUITE(ConvertBbAuthLastAuths) {
    Y_UNIT_TEST(buildQuery) {
        NExtend::TAuthExtendedEntry entry;
        entry.Row.Timestamp = TInstant::ParseIso8601("2010-03-16T11:02:55.123456+03");
        entry.Row.Uid = 18293612;
        entry.Row.AuthType = "web";
        entry.Row.Status = "kek";

        UNIT_ASSERT(!TLastAuth::BuildQuery(entry));

        entry.Row.Status = "ses_update";
        UNIT_ASSERT_VALUES_EQUAL(
            *TLastAuth::BuildQuery(entry),
            NHbase::TQuery({
                .Row = "18293612",
                .Params = {
                    {"c:lastauth", "1268726575.12"},
                    {"c:type", "web"},
                },
            }));
    }
}
