#include <passport/infra/daemons/lbchdb/src/hbase_converters/event_converter.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/output.h>

using namespace NPassport;
using namespace NPassport::NLb;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NExtend;
using namespace NPassport::NLbchdb::NParser;
using namespace NPassport::NLbchdb::NHBaseConv;
using namespace NPassport::NLbchdb::NHBaseConv::NEvent;
using namespace std::literals;

Y_UNIT_TEST_SUITE(EventConverter) {
    Y_UNIT_TEST(Empty) {
        TEventConverter conv;

        NHbase::TQuery q{
            .Type = NHbase::TQuery::EType::Put,
            .Row = "4072891060_9223372035232826556.373310_-.info.password-update-time",
            .Params = {
                {"c:name", "info.password_update_time"},
            },
        };

        TEventExtendedEntry entry;
        entry.Row.Uid = 4072891060;
        entry.Row.Timestamp = TInstant::ParseIso8601("2021-05-25T16:27:31.626690+03");
        entry.Row.Name = "info.password_update_time";
        conv.Process(std::move(entry));

        NHbase::TQueries qs = conv.Finish();

        UNIT_ASSERT(qs.ByTable.contains("events"));
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("events").size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("events")[0], q);
    }

    Y_UNIT_TEST(FullRow) {
        TEventConverter conv;

        NHbase::TQuery q{
            .Type = NHbase::TQuery::EType::Put,
            .Row = "4072891060_9223372035232826556.373310_71.info.password-update-time",
            .Params = {
                {"c:host_id", "71"},
                {"c:client_name", "passport"},
                {"c:name", "info.password_update_time"},
                {"c:value", "1621949251"},
                {"c:yandexuid", "23"},
                {"c:admin", "ads"},
                {"c:comment", "fdas"},
                {"c:user_ip", "12.23.34.45"},
                {"c:ip.geoid", "103316"},
                {"c:ip.as_list", "AS7018"},
            },
        };

        TEventExtendedEntry entry{
            .Row = {
                .ClientName = "passport",
                .EventValue = "1621949251",
                .UserIp = "37.9.101.77",
                .ProxyIp = "12.23.34.45",
                .YandexUid = "23",
                .AdminLogin = "ads",
                .Comment = "fdas",
            },
            .IpData = TIpData{
                .GeoId = 103316,
                .As = "AS7018",
            },
        };
        entry.Row.Uid = 4072891060;
        entry.Row.Timestamp = TInstant::ParseIso8601("2021-05-25T16:27:31.626690+03");
        entry.Row.HostId = 71;
        entry.Row.Name = "info.password_update_time";

        conv.Process(std::move(entry));

        NHbase::TQueries qs = conv.Finish();

        UNIT_ASSERT(qs.ByTable.contains("events"));
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("events").size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("events")[0], q);
    }

    Y_UNIT_TEST(IpEvent) {
        TEventConverter conv;
        NHbase::TQuery qEvent{
            .Type = NHbase::TQuery::EType::Put,
            .Row = "4072297906_9223372035233578992.481083_71.action",
            .Params = {
                {"c:host_id", "71"},
                {"c:client_name", "passport"},
                {"c:name", "action"},
                {"c:value", "account_create"},
                {"c:user_ip", "37.9.101.77"},
                {"c:ip.geoid", "213"},
                {"c:ip.as_list", "AS13238"},
            },
        };

        NHbase::TQuery qIpEvent{
            .Type = NHbase::TQuery::EType::Put,
            .Row = NUtils::Base64ToBin("AAAAAAAAAAAAAP//JQllTQAAAAF/////n15/8AAHVzsAAAAA8rpVsgAAAEc="),
            .Params = {
                {"c:host_id", "71"},
                {"c:client_name", "passport"},
                {"c:name", "action"},
                {"c:value", "account_create"},
                {"c:uid", "4072297906"},
            },
        };

        TEventExtendedEntry entry{
            .Row = {
                .ClientName = "passport",
                .EventValue = "account_create",
                .UserIp = "37.9.101.77"},
            .IpData = TIpData{
                .GeoId = 213,
                .As = "AS13238",
                .Packed = NUtils::TIpAddr("37.9.101.77").ToPackedStringV6(),
                .PackedShortest = NUtils::TIpAddr("37.9.101.77").ToPackedStringShortest(),
                .Unpacked = "37.9.101.77",
            },
        };
        entry.Row.Uid = 4072297906;
        entry.Row.Timestamp = TInstant::ParseIso8601("2021-05-16T23:26:55.518917+03");
        entry.Row.Name = "action";
        entry.Row.HostId = 71;
        conv.Process(std::move(entry));

        NHbase::TQueries qs = conv.Finish();

        UNIT_ASSERT(qs.ByTable.contains("events"));
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("events").size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("events")[0], qEvent);

        UNIT_ASSERT(qs.ByTable.contains("ip_events"));
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("ip_events").size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("ip_events")[0], qIpEvent);
    }
}
