#include <passport/infra/daemons/lbchdb/src/hbase_converters/mail_user_journal/users_history.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NHBaseConv::NMailUserJournal;

Y_UNIT_TEST_SUITE(ConvertHBaseMailUserJournalUsersHistory) {
    Y_UNIT_TEST(ignoreField) {
        UNIT_ASSERT(!TUsersHistory::IgnoreField("operation"));
        UNIT_ASSERT(!TUsersHistory::IgnoreField("ip"));

        for (auto field : {"uid", "date", "version", "tableName", "tskv_format"}) {
            UNIT_ASSERT(TUsersHistory::IgnoreField(field));
        }
    }

    Y_UNIT_TEST(buildRow) {
        NParser::TMailUserJournalRow entry;
        entry.Uid = 1130000000003456;
        entry.Date = 1597870942048;
        UNIT_ASSERT_VALUES_EQUAL("1130000000003456_18446742475838609568_", TUsersHistory::BuildRow(entry));

        entry.Date = 1;
        entry.Tskv = NRowParsers::TTskvRow(NRowParsers::TTskvRow::TFields{
            {"operation", "move_to_tab"},
        });
        UNIT_ASSERT_VALUES_EQUAL("1130000000003456_18446744073709551615_move_to_tab", TUsersHistory::BuildRow(entry));
    }

    Y_UNIT_TEST(buildQuery) {
        NParser::TMailUserJournalRow entry;
        entry.Uid = 100500;
        entry.Date = 12345678;

        UNIT_ASSERT_VALUES_EQUAL(
            *TUsersHistory::BuildQuery(entry),
            NHbase::TQuery({
                .Row = "100500_18446744073697205938_",
                .Params = {},
            }));

        entry.Tskv = NRowParsers::TTskvRow({
            {"uid", "1234"},
            {"version", "2"},
            {"operation", "imap_copy"},
            {"tableName", "corp_lastauth"},
            {"empty", ""},
            {"target", "message"},
            {"date", "123456789"},
            {"ip", "127.0.0.1"},
            {"tskv_format", "mail-user-journal"},
        });

        UNIT_ASSERT_VALUES_EQUAL(
            *TUsersHistory::BuildQuery(entry),
            NHbase::TQuery({
                .Row = "100500_18446744073697205938_imap_copy",
                .Params = {
                    {"cf:ip", "127.0.0.1"},
                    {"cf:operation", "imap_copy"},
                    {"cf:target", "message"},
                },
            }));
    }
}
