#include <passport/infra/daemons/lbchdb/src/extenders/oauth_extender.h>
#include <passport/infra/daemons/lbchdb/src/hbase_converters/oauth_converter.h>

#include <passport/infra/libs/cpp/utils/ipaddr.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/output.h>

using namespace NPassport;
using namespace NPassport::NHbase;
using namespace NPassport::NLbchdb;
using namespace std::literals;

Y_UNIT_TEST_SUITE(OAuthConverter) {
    Y_UNIT_TEST(Full) {
        NHBaseConv::TOAuthConverter conv;

        NHbase::TQuery q{
            .Type = NHbase::TQuery::EType::Put,
            .Row = NUtils::Base64ToBin("ODc0AAAAAPLQE/r/+R83cGFzc3dvcmQtb2F1dGg="),
            .Params = {
                {NUtils::Base64ToBin("aToKDnBhc3N3b3JkLW9hdXRoEhkKEAAAAAAAAAAAAAD//7ug8BcQraYBGPBcKmkKIDE4OTgzMDM0MzRhZjQyNjI4MmNlN2Q0NWM4OTYyOWMxEggyNjQ3MTM1NBoXbXlfZGV2aWNlX2lkX0xrTnFaSFB3eloiDm15X2RldmljZV9uYW1lKhJvYXV0aDpncmFudF94dG9rZW4="),
                 "1622736401.47"},
            },
        };

        TString ip = "187.160.240.23";
        conv.Process(NExtend::TOAuthExtendedEntry{
            .Row = {
                .Timestamp = TInstant::Seconds(1622736401) + TDuration::MicroSeconds(472587),
                .TokenId = "26471354",
                .ClientId = "1898303434af426282ce7d45c89629c1",
                .DeviceId = "my_device_id_LkNqZHPwzZ",
                .DeviceName = "my_device_name",
                .Scopes = "oauth:grant_xtoken",
                .UserIp = ip,
                .Uid = 4073722874,
            },
            .IpData = NExtend::TIpData{
                .GeoId = 21293,
                .As = "AS11888",
                .Packed = NUtils::TIpAddr(ip).ToPackedStringV6(),
                .PackedShortest = NUtils::TIpAddr(ip).ToPackedStringShortest(),
                .Unpacked = ip,
                .IsReal = true,
                .IsYandex = false,
            },
        });

        NHbase::TQueries qs = conv.Finish();

        UNIT_ASSERT(qs.ByTable.contains("success_auths_uids_by_hour"));
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("success_auths_uids_by_hour").size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("success_auths_uids_by_hour")[0], q);
    }

    Y_UNIT_TEST(Minimal) {
        NHBaseConv::TOAuthConverter conv;

        NHbase::TQuery q{
            .Type = NHbase::TQuery::EType::Put,
            .Row = NUtils::Base64ToBin("ODc0AAAAAPLQE/r/+R83cGFzc3dvcmQtb2F1dGg="),
            .Params = {
                {NUtils::Base64ToBin("aToKDnBhc3N3b3JkLW9hdXRoEhkKEAAAAAAAAAAAAAD//7ug8BcQraYBGPBcKiwKIGVkNTRkNWY2MWRiNDRmNDZiYmY1YzQwYzI0ZGQ1NjMzEggyNjQ3MTM1Mg=="),
                 "1622736400.0"},
            },
        };

        TString ip = "187.160.240.23";
        conv.Process(NExtend::TOAuthExtendedEntry{
            .Row = {
                .Timestamp = TInstant::Seconds(1622736400),
                .TokenId = "26471352",
                .ClientId = "ed54d5f61db44f46bbf5c40c24dd5633",
                .UserIp = ip,
                .Uid = 4073722874,
            },
            .IpData = NExtend::TIpData{
                .GeoId = 21293,
                .As = "AS11888",
                .Packed = NUtils::TIpAddr(ip).ToPackedStringV6(),
                .PackedShortest = NUtils::TIpAddr(ip).ToPackedStringShortest(),
                .Unpacked = ip,
                .IsReal = true,
                .IsYandex = false,
            },
        });

        NHbase::TQueries qs = conv.Finish();

        UNIT_ASSERT(qs.ByTable.contains("success_auths_uids_by_hour"));
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("success_auths_uids_by_hour").size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("success_auths_uids_by_hour")[0], q);
    }

    Y_UNIT_TEST(Incomplete) {
        NHBaseConv::TOAuthConverter conv;

        // Missing packed ip (invalid ip)
        TString ip = "187.160.240.23";
        conv.Process(NExtend::TOAuthExtendedEntry{
            .Row = {
                .Timestamp = TInstant::Seconds(1622736400) + TDuration::MicroSeconds(975631),
                .TokenId = "26471352",
                .ClientId = "ed54d5f61db44f46bbf5c40c24dd5633",
                .UserIp = ip,
                .Uid = 4073722874,
            },
            .IpData = NExtend::TIpData{
                .GeoId = 21293,
                .As = "AS11888",
                .PackedShortest = NUtils::TIpAddr(ip).ToPackedStringShortest(),
                .Unpacked = ip,
                .IsReal = true,
                .IsYandex = false,
            },
        });

        // No client id
        conv.Process(NExtend::TOAuthExtendedEntry{
            .Row = {
                .Timestamp = TInstant::Seconds(1622736400) + TDuration::MicroSeconds(975631),
                .TokenId = "26471352",
                .UserIp = ip,
                .Uid = 4073722874,
            },
            .IpData = NExtend::TIpData{
                .GeoId = 21293,
                .As = "AS11888",
                .Packed = NUtils::TIpAddr(ip).ToPackedStringV6(),
                .PackedShortest = NUtils::TIpAddr(ip).ToPackedStringShortest(),
                .Unpacked = ip,
                .IsReal = true,
                .IsYandex = false,
            },
        });

        // No ip data
        conv.Process(NExtend::TOAuthExtendedEntry{
            .Row = {
                .Timestamp = TInstant::Seconds(1622736400) + TDuration::MicroSeconds(975631),
                .TokenId = "26471352",
                .ClientId = "ed54d5f61db44f46bbf5c40c24dd5633",
                .UserIp = ip,
                .Uid = 4073722874,
            },
        });

        // No token id
        conv.Process(NExtend::TOAuthExtendedEntry{
            .Row = {
                .Timestamp = TInstant::Seconds(1622736400) + TDuration::MicroSeconds(975631),
                .ClientId = "ed54d5f61db44f46bbf5c40c24dd5633",
                .UserIp = ip,
                .Uid = 4073722874,
            },
            .IpData = NExtend::TIpData{
                .GeoId = 21293,
                .As = "AS11888",
                .Packed = NUtils::TIpAddr(ip).ToPackedStringV6(),
                .PackedShortest = NUtils::TIpAddr(ip).ToPackedStringShortest(),
                .Unpacked = ip,
                .IsReal = true,
                .IsYandex = false,
            },
        });

        NHbase::TQueries qs = conv.Finish();

        UNIT_ASSERT(qs.ByTable.contains("success_auths_uids_by_hour"));
        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("success_auths_uids_by_hour").size(), 0);
    }
}
