#include <passport/infra/daemons/lbchdb/src/hbase_converters/restore_converter.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/output.h>

using namespace NPassport;
using namespace NPassport::NLb;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NParser;
using namespace NPassport::NLbchdb::NHBaseConv;
using namespace NPassport::NLbchdb::NHBaseConv::NEvent;

Y_UNIT_TEST_SUITE(RestoreConverter) {
    Y_UNIT_TEST(SimpleRow) {
        NHbase::TQuery q{
            .Type = NHbase::TQuery::EType::Put,
            .Row = "1_9223372035233522656.329798_-.-",
            .Params = {
                {"r:restore_id", "b"},
                {"r:action", "a"},
                {"r:data_json", "{}"},
            },
        };
        TRestoreRow row;
        row.RestoreId = q.Params[0].second;
        row.Action = q.Params[1].second;
        row.DataJson = q.Params[2].second;
        row.Uid = 1;
        row.Timestamp = TInstant::ParseIso8601("2021-05-17T15:05:51.670202+03");

        TRestoreConverter conv;
        conv.Process(row);
        NHbase::TQueries qs = conv.Finish();

        UNIT_ASSERT_VALUES_EQUAL(qs.ByTable.at("events")[0], q);
    }
}
