#include <passport/infra/daemons/lbchdb/ut/common.h>

#include <passport/infra/daemons/lbchdb/src/hbase_converters/utils.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NHBaseConv;

Y_UNIT_TEST_SUITE(ConvertUtils) {
    Y_UNIT_TEST(asBool) {
        UNIT_ASSERT_VALUES_EQUAL(TUtils::AsBool(true), "1");
        UNIT_ASSERT_VALUES_EQUAL(TUtils::AsBool(false), "0");
    }

    Y_UNIT_TEST(optionalString) {
        UNIT_ASSERT_VALUES_EQUAL(TUtils::OptionalString(""), "-");
        UNIT_ASSERT_VALUES_EQUAL(TUtils::OptionalString("aasd"), "aasd");
    }

    Y_UNIT_TEST(printTimeInPythonStyle) {
        UNIT_ASSERT_VALUES_EQUAL(TUtils::PrintTimeInPythonStyle(TInstant::ParseIso8601("2010-03-16T11:02:55.123456+03")),
                                 "1268726575.12");
    }
}
