#include <passport/infra/daemons/lbchdb/src/crypto/decryptor.h>
#include <passport/infra/daemons/lbchdb/src/hbase_converters/yasms_private_converter/yasms_sms_history.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NCrypto;
using namespace NPassport::NLbchdb::NParser;
using namespace NPassport::NLbchdb::NHBaseConv::NYasmsPrivate;

Y_UNIT_TEST_SUITE(ConvertYasmsUserHistory) {
    Y_UNIT_TEST(buildSmsHistoryByPhoneRow) {
        TYasmsPrivateRow entry;

        UNIT_ASSERT_VALUES_EQUAL("phone:::0_", TSmsHistory::BuildSmsHistoryByPhoneRow(entry));

        entry.Timestamp = TInstant::MilliSeconds(1234567890);
        entry.Action = "someaction";
        entry.Number = "somenumber";
        entry.GlobalSmsId = "somesmsid";
        UNIT_ASSERT_VALUES_EQUAL("phone:somenumber:somesmsid:1234567890000_someaction",
                                 TSmsHistory::BuildSmsHistoryByPhoneRow(entry));
    }

    Y_UNIT_TEST(buildGlobalSmsIdToPhoneRow) {
        TYasmsPrivateRow entry;

        UNIT_ASSERT_VALUES_EQUAL("gsmsid::0_", TSmsHistory::BuildGlobalSmsIdToPhoneRow(entry));

        entry.Timestamp = TInstant::MilliSeconds(1234567890);
        entry.Action = "someaction";
        entry.GlobalSmsId = "somesmsid";
        UNIT_ASSERT_VALUES_EQUAL("gsmsid:somesmsid:1234567890000_someaction",
                                 TSmsHistory::BuildGlobalSmsIdToPhoneRow(entry));
    }

    Y_UNIT_TEST(buildUidToPhoneRow) {
        TYasmsPrivateRow entry;

        UNIT_ASSERT_VALUES_EQUAL("uid:0:0_", TSmsHistory::BuildUidToPhoneRow(entry));

        entry.Timestamp = TInstant::MilliSeconds(1234567890);
        entry.Action = "someaction";
        entry.Uid = 100500;
        UNIT_ASSERT_VALUES_EQUAL("uid:100500:1234567890000_someaction",
                                 TSmsHistory::BuildUidToPhoneRow(entry));
    }

    Y_UNIT_TEST(buildParams) {
        TDecryptor d(nullptr);
        NHbase::TQuery q;

        TYasmsPrivateRow entry;
        entry.GlobalSmsId = "someid";
        entry.Action = "someaction";
        entry.Timestamp = TInstant::MicroSeconds(1234567890);
        entry.Number = "+88005553535";
        entry.Uid = 100500;
        entry.Text = "some decrypted text";

        TSmsHistory::BuildParams(entry, q);
        UNIT_ASSERT_VALUES_EQUAL(
            q,
            NHbase::TQuery({
                .Params = {
                    {"c:sms", "1"},
                    {"c:global_smsid", "someid"},
                    {"c:action", "someaction"},
                    {"c:timestamp", "1234.57"},
                    {"c:number", "+88005553535"},
                    {"c:uid", "100500"},
                    {"c:text", "some decrypted text"},
                },
            }));
        q.Params.clear();

        entry.TryParse("tskv\ttskv_format=yasms-log\tsms=1\tnumber=+88005553535\tglobal_smsid=someid\taction=someaction\tunixtimef=1234.567890\tunixtime=129666\tkek=lol", d);
        TSmsHistory::BuildParams(entry, q);
        UNIT_ASSERT_VALUES_EQUAL(
            q,
            NHbase::TQuery({
                .Params = {
                    {"c:sms", "1"},
                    {"c:global_smsid", "someid"},
                    {"c:action", "someaction"},
                    {"c:timestamp", "1234.57"},
                    {"c:number", "+88005553535"},
                    {"c:kek", "lol"},
                },
            }));
        q.Params.clear();
    }

    Y_UNIT_TEST(buildUidToPhoneQuery) {
        TYasmsPrivateRow entry;

        UNIT_ASSERT(!TSmsHistory::BuildUidToPhoneQuery(entry));

        entry.Uid = 42;
        UNIT_ASSERT(!TSmsHistory::BuildUidToPhoneQuery(entry));

        entry.Action = "kek";
        UNIT_ASSERT(!TSmsHistory::BuildUidToPhoneQuery(entry));

        entry.Action = "enqueued";
        UNIT_ASSERT(TSmsHistory::BuildUidToPhoneQuery(entry));

        entry.Uid = 0;
        UNIT_ASSERT(!TSmsHistory::BuildUidToPhoneQuery(entry));
    }
}
