#include <passport/infra/daemons/lbchdb/src/crypto/decryptor.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb::NCrypto;

Y_UNIT_TEST_SUITE(ProcDecryptor) {
    Y_UNIT_TEST(decrypt) {
        TDecryptor d(std::make_unique<TSimpleKeyRing>(TSimpleKeyRing::TKeys{
            {618, NUtils::Base64ToBin("S2wnG2nRMHJHbNIiEPjjD5r/vMSbFRd/cAk683DTETo=")},
        }));

        // missing iv
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt(""),
                                       yexception,
                                       R"(Decryptor: invalid format of encrypted string)");
        // missing ciphertext
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("a:"),
                                       yexception,
                                       R"(Decryptor: invalid format of encrypted string)");
        // missing associatedData
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("a:b:"),
                                       yexception,
                                       R"(Decryptor: invalid format of encrypted string)");
        // missing authTag
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("a:b:c:"),
                                       yexception,
                                       R"(Decryptor: invalid format of encrypted string)");
        // unexpected fields in the end
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("a:b:c:d:e"),
                                       yexception,
                                       R"(Decryptor: invalid format of encrypted string)");

        // bad base64 in iv
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("a:b:c:d"),
                                       yexception,
                                       R"(Decryptor: invalid base64 in encrypted string)");
        // bad base64 in ciphertext
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("aaaa:b:c:d"),
                                       yexception,
                                       R"(Decryptor: invalid base64 in encrypted string)");
        // bad base64 in authTag
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("aaaa:bbbb:c:d"),
                                       yexception,
                                       R"(Decryptor: invalid base64 in encrypted string)");

        // invalid format for key id
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("aaaa:bbbb:c:dddd"),
                                       yexception,
                                       R"(Decryptor: invalid key id in encrypted string: '')");
        // invalid key id
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("aaaa:bbbb:c=kek:dddd"),
                                       yexception,
                                       R"(Decryptor: invalid key id in encrypted string: 'kek')");

        // missing key
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("aaaa:bbbb:c=18:dddd"),
                                       yexception,
                                       "No key for id '18'");

        // bad crypto
        UNIT_ASSERT_EXCEPTION_CONTAINS(d.Decrypt("aaaa:bbbb:c=618:dddd"),
                                       yexception,
                                       R"(Decryptor: failed to decrypt with aes gcm: )");

        UNIT_ASSERT_VALUES_EQUAL("Your confirmation code is 540870. Please enter it in the text field.",
                                 d.Decrypt("b0z9A+1+8BvDbAiB:j63kcG/xsTVMAdnbg63rKLKHbTvtGlrcEyeoNYAaJkgMDNZQ06WfSOPEUxWKWdg/mpoYtV9bRcBJIsXF2FJzx7avezM=:key_number=618:sOtr+3Ez4kpi+pbDWBM2eQ=="));
    }
}
