#include <passport/infra/daemons/lbchdb/src/crypto/encryptor.h>

#include <passport/infra/libs/cpp/utils/crypto/hash.h>
#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb::NCrypto;

Y_UNIT_TEST_SUITE(ProcEncryptor) {
    Y_UNIT_TEST(encrypt) {
        TEncryptor::TKeyRingMap keyRingMap;
        keyRingMap.try_emplace(
            TEncryptor::EKeyRing::Restore,
            std::make_unique<TSimpleKeyRing>(TSimpleKeyRing::TKeys{
                {18, NUtils::Base64ToBin("d3afIKJ+MB2ZnAMxwsNQN729osL9meb33YP/5wilfCU=")},
                {129, NUtils::Base64ToBin("eik8oMR/sfgUE0O4NEaY/yGgtkfbN3sBCRiyqS0ZDV0=")},
            }),
            129);

        TEncryptor d(std::move(keyRingMap));

        TEncryptor::TEncryptResult res = d.Encrypt("some very important data", TEncryptor::EKeyRing::Restore);
        UNIT_ASSERT_VALUES_EQUAL(res.KeyId, 129);
        TString decoded;
        TString err;
        UNIT_ASSERT_C(NUtils::TCrypto::DecryptGcm(
                          NUtils::Base64ToBin("eik8oMR/sfgUE0O4NEaY/yGgtkfbN3sBCRiyqS0ZDV0="),
                          res.Crypt,
                          decoded,
                          &err), err);
        UNIT_ASSERT_VALUES_EQUAL(decoded, "some very important data");
    }
}
