#include <passport/infra/daemons/lbchdb/src/helpers/auths_helper.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NHelpers;

Y_UNIT_TEST_SUITE(AuthsHelper) {
    Y_UNIT_TEST(isWebSuccessful) {
        NParser::TAuthRow row;
        row.AuthType = "web";
        row.Status = "successful";

        UNIT_ASSERT(!TAuthsHelper::IsWebSuccessful(row));

        row.ClientName = "bb";
        UNIT_ASSERT(TAuthsHelper::IsWebSuccessful(row));

        row.AuthType = "web";
        row.Status = "failed";
        UNIT_ASSERT(!TAuthsHelper::IsWebSuccessful(row));

        row.AuthType = "oauth";
        row.Status = "successful";
        UNIT_ASSERT(!TAuthsHelper::IsWebSuccessful(row));

        row.AuthType = "oauth";
        row.Status = "failed";
        UNIT_ASSERT(!TAuthsHelper::IsWebSuccessful(row));
    }

    Y_UNIT_TEST(isSuccessAuth) {
        NParser::TAuthRow row;
        row.AuthType = "web";
        row.Status = "successful";

        UNIT_ASSERT(TAuthsHelper::IsSuccessAuth(row, false));
        UNIT_ASSERT(TAuthsHelper::IsSuccessAuth(row, true));

        row.ClientName = "bb";
        UNIT_ASSERT(!TAuthsHelper::IsSuccessAuth(row, false));
        UNIT_ASSERT(!TAuthsHelper::IsSuccessAuth(row, true));

        row.AuthType = "oauth";
        UNIT_ASSERT(TAuthsHelper::IsSuccessAuth(row, false));
        UNIT_ASSERT(TAuthsHelper::IsSuccessAuth(row, true));

        row.Status = "ses_create";
        UNIT_ASSERT(TAuthsHelper::IsSuccessAuth(row, false));
        UNIT_ASSERT(TAuthsHelper::IsSuccessAuth(row, true));

        row.Status = "ses_update";
        UNIT_ASSERT(!TAuthsHelper::IsSuccessAuth(row, false));
        UNIT_ASSERT(TAuthsHelper::IsSuccessAuth(row, true));
    }

    Y_UNIT_TEST(IsFailedAuthStatus) {
        UNIT_ASSERT(TAuthsHelper::IsFailedAuthStatus("failed"));
        UNIT_ASSERT(TAuthsHelper::IsFailedAuthStatus("bruteforce"));
        UNIT_ASSERT(TAuthsHelper::IsFailedAuthStatus("disabled"));
        UNIT_ASSERT(TAuthsHelper::IsFailedAuthStatus("blocked"));
        UNIT_ASSERT(TAuthsHelper::IsFailedAuthStatus("challenge_shown"));
        UNIT_ASSERT(!TAuthsHelper::IsFailedAuthStatus("ses_create"));
        UNIT_ASSERT(!TAuthsHelper::IsFailedAuthStatus("ses_update"));
        UNIT_ASSERT(!TAuthsHelper::IsFailedAuthStatus("successful"));
    }

    Y_UNIT_TEST(IsSampledAuth) {
        UNIT_ASSERT(TAuthsHelper::IsSampledAuthtype("oauthcheck"));
        UNIT_ASSERT(!TAuthsHelper::IsSampledAuthtype("ses_update"));
    }

    Y_UNIT_TEST(buildSamplingKey) {
        NExtend::TAuthExtendedEntry entry;
        entry.Row.Timestamp = TInstant::ParseIso8601("2010-03-16T11:07:55.123456+03");
        entry.Row.AuthType = "oauth_kek";
        entry.Row.Uid = 789;
        entry.Row.HostId = 127;
        entry.Row.ProxyIp = "someip#1";
        entry.Row.UserIp = "someip#2";
        entry.Comment = NExtend::TComment::Create("tokid=value1;");

        UNIT_ASSERT_VALUES_EQUAL(TAuthsHelper::BuildSamplingKey(entry, 300),
                                 "1268726700;789;value1;someip#1");
        UNIT_ASSERT_VALUES_EQUAL(TAuthsHelper::BuildSamplingKey(entry, 600),
                                 "1268726400;789;value1;someip#1");
    }

    Y_UNIT_TEST(buildKeyUniquePart) {
        NExtend::TAuthExtendedEntry entry;
        entry.Row.AuthType = "oauth_kek";
        entry.Row.HostId = 789;

        entry.Comment = NExtend::TComment::Create("tokid=asdasdkjasndaskd");
        UNIT_ASSERT_VALUES_EQUAL(TAuthsHelper::BuildKeyUniquePart(entry, false), "789");
        UNIT_ASSERT_VALUES_EQUAL(TAuthsHelper::BuildKeyUniquePart(entry, true), "oauth_kek/asdasdkjasndaskd");

        entry.Comment = {};
        UNIT_ASSERT_VALUES_EQUAL(TAuthsHelper::BuildKeyUniquePart(entry, false), "789");
        UNIT_ASSERT_VALUES_EQUAL(TAuthsHelper::BuildKeyUniquePart(entry, true), "oauth_kek/-");
    }
}
