#include "common.h"

#include <passport/infra/daemons/lbchdb/src/blackbox_client.h>
#include <passport/infra/daemons/lbchdb/src/extenders/event_extender.h>
#include <passport/infra/daemons/lbchdb/src/extenders/oauth_extender.h>
#include <passport/infra/daemons/lbchdb/src/parsers/auth_parser.h>
#include <passport/infra/daemons/lbchdb/src/parsers/event_parser.h>
#include <passport/infra/daemons/lbchdb/src/parsers/oauth_parser.h>
#include <passport/infra/daemons/lbchdb/src/parsers/push_parser.h>
#include <passport/infra/daemons/lbchdb/src/parsers/push_subscription_parser.h>
#include <passport/infra/daemons/lbchdb/src/parsers/restore_parser.h>
#include <passport/infra/daemons/lbchdb/src/yt_converters/auth/last_auth.h>

#include <optional>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLb;

#define OUT_IMPL(TYPE)                                                                   \
    template <>                                                                          \
    void Out<std::optional<TYPE>>(IOutputStream & o, const std::optional<TYPE>& value) { \
        if (value) {                                                                     \
            o << *value;                                                                 \
        } else {                                                                         \
            o << "(NULL)";                                                               \
        }                                                                                \
    }

OUT_IMPL(ui32);
OUT_IMPL(ui64);
OUT_IMPL(std::string);
OUT_IMPL(TString);
OUT_IMPL(TStringBuf);
OUT_IMPL(NExtend::TIpData);
OUT_IMPL(NExtend::TUserAgentData);
OUT_IMPL(NParser::TOAuthRow);
OUT_IMPL(NExtend::TLaasInfo);
OUT_IMPL(NYtConv::NAuth::TLastAuthEntry);

#undef OUT_IMPL

template <>
void Out<NParser::TEventRow>(IOutputStream& o, const NParser::TEventRow& value) {
    o << "row: " << value.Name << " " << value.Uid << " " << value.Timestamp << Endl
      << "c:client_name -> " << value.ClientName << Endl
      << "c:host_id -> " << value.HostId << Endl
      << "c:name -> " << value.Name << Endl
      << "c:user_ip -> " << value.UserIp << Endl
      << "c:proxy_ip -> " << value.ProxyIp << Endl
      << "c:value -> " << value.EventValue << Endl
      << "c:yandex_uid -> " << value.YandexUid << Endl
      << "c:admin -> " << value.AdminLogin << Endl
      << "c:comment -> " << value.Comment;
}

template <>
void Out<NExtend::TEventExtendedEntry>(IOutputStream& o, const NExtend::TEventExtendedEntry& value) {
    o << value.Row << Endl
      << value.IpData;
}

template <>
void Out<NExtend::TOAuthExtendedEntry>(IOutputStream& o, const NExtend::TOAuthExtendedEntry& value) {
    o << value.Row << Endl
      << value.IpData;
}

template <>
void Out<NParser::TRestoreRow>(IOutputStream& o, const NParser::TRestoreRow& value) {
    o << "name -> " << value.Name << Endl
      << "host_id -> " << value.HostId << Endl
      << "uid -> " << value.Uid << Endl
      << "restore_id -> " << value.RestoreId << Endl
      << "action -> " << value.Action << Endl
      << "data_json -> " << value.DataJson << Endl
      << "rfctime -> " << value.Timestamp;
}

template <>
void Out<NParser::TOAuthRow>(IOutputStream& o, const NParser::TOAuthRow& value) {
    o << "timestamp -> " << value.Timestamp << Endl
      << "token_id -> " << value.TokenId << Endl
      << "client_id -> " << value.ClientId << Endl
      << "scopes -> " << value.Scopes << Endl
      << "user_ip -> " << value.UserIp << Endl
      << "uid -> " << value.Uid;
}

template <>
void Out<NParser::TPushRow>(IOutputStream& o, const NParser::TPushRow& value) {
    o << "uid -> " << value.Uid << Endl
      << "unixtime -> " << value.Unixtime << Endl
      << "push_id -> " << value.PushId << Endl
      << "subscription_id -> " << value.SubscriptionId << Endl
      << "app_id -> " << value.AppId << Endl
      << "device_id -> " << value.DeviceId << Endl
      << "push_service -> " << value.PushService << Endl
      << "push_event -> " << value.PushEvent << Endl
      << "details -> " << value.Details << Endl
      << "status -> " << value.Status << Endl
      << "context -> " << value.Context << Endl;
}

template <>
void Out<NParser::TPushSubscriptionRow>(IOutputStream& o, const NParser::TPushSubscriptionRow& value) {
    o << "uid -> " << value.Uid << Endl
      << "app_id -> " << value.AppId << Endl
      << "device_id -> " << value.DeviceId << Endl
      << "unixtime -> " << value.Unixtime << Endl;
}

template <>
void Out<NExtend::TIpData>(IOutputStream& o, const NExtend::TIpData& value) {
    auto prOpt = [&o](TString key, auto v) {
        o << key << "=";
        if (v) {
            o << *v;
        } else {
            o << "<NULL>";
        }
        o << Endl;
    };

    prOpt("geoid", value.GeoId);
    prOpt("AS", value.As);
    o << "packed=" << NUtils::Bin2hex(value.Packed) << Endl;
    o << "packedShortest=" << NUtils::Bin2hex(value.PackedShortest) << Endl;
    o << "unpacked=" << value.Unpacked << Endl;
    o << "isReal_=" << value.IsReal << Endl;
    o << "isYandex_=" << value.IsYandex << Endl;
}

template <>
void Out<NExtend::TUserAgentData>(IOutputStream& o, const NExtend::TUserAgentData& value) {
    o << "browserName=" << value.BrowserName << Endl;
    o << "browserVersion=" << value.BrowserVersion << Endl;
    o << "osName=" << value.OsName << Endl;
    o << "osFamily=" << value.OsFamily << Endl;
    o << "osVersion=" << value.OsVersion << Endl;
}

template <>
void Out<NExtend::TComment>(IOutputStream& o, const NExtend::TComment& value) {
    o << value.PrintDebug();
}

template <>
void Out<NParser::TAuthRow>(IOutputStream& o, const NParser::TAuthRow& value) {
    o << "timestamp=" << value.Timestamp << Endl;
    o << "hostId=" << value.HostId << Endl;
    o << "uid=" << value.Uid << Endl;
    o << "login=" << value.Login << Endl;
    o << "sid=" << value.Sid << Endl;
    o << "authtype=" << value.AuthType << Endl;
    o << "status=" << value.Status << Endl;
    o << "comment=" << value.Comment << Endl;
    o << "userIp=" << value.UserIp << Endl;
    o << "proxyIp=" << value.ProxyIp << Endl;
    o << "yandexuid=" << value.YandexUid << Endl;
    o << "useragent=" << value.UserAgent << Endl;
}

template <>
void Out<NExtend::TLaasInfo>(IOutputStream& o, const NExtend::TLaasInfo& value) {
    o << value.ToString();
}

template <>
void Out<IBlackboxClient::TRequest>(IOutputStream& o, const IBlackboxClient::TRequest& value) {
    o << value.Path << Endl;
    o << value.Body << Endl;
}

template <>
void Out<NYtConv::NAuth::TLastAuthFilter::TEntries>(IOutputStream& o, const NYtConv::NAuth::TLastAuthFilter::TEntries& value) {
    for (const auto& [key, value] : value) {
        o << "key: " << key << ", value=" << value << Endl;
    }
}
