#include <passport/infra/daemons/lbchdb/src/parsers/mail_user_journal_parser.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NParser;
using namespace std::literals;

Y_UNIT_TEST_SUITE(MailUserJournalParser) {
    Y_UNIT_TEST(tryParse) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TMailUserJournalParser::TryParse(""),
                                       yexception,
                                       "line should start with 'tskv'");

        UNIT_ASSERT_EXCEPTION_CONTAINS(TMailUserJournalParser::TryParse("\x00"),
                                       yexception,
                                       "line should start with 'tskv'");

        UNIT_ASSERT_EXCEPTION_CONTAINS(TMailUserJournalParser::TryParse("tskv\ta=b\tc=d"),
                                       yexception,
                                       "no field 'uid'");

        UNIT_ASSERT_EXCEPTION_CONTAINS(TMailUserJournalParser::TryParse("tskv\tuid=foo\tc=d"),
                                       yexception,
                                       "invalid number in 'uid': 'foo'");

        UNIT_ASSERT_EXCEPTION_CONTAINS(TMailUserJournalParser::TryParse("tskv\tuid=1111\tc=d"),
                                       yexception,
                                       "no field 'date'");

        UNIT_ASSERT_EXCEPTION_CONTAINS(TMailUserJournalParser::TryParse("tskv\tuid=1111\tdate=-"),
                                       yexception,
                                       "invalid number in 'date': '-'");

        UNIT_ASSERT_EXCEPTION_CONTAINS(TMailUserJournalParser::TryParse("tskv\tdate=12345\tuid=1111\tv=yes"),
                                       yexception,
                                       "invalid number in 'v': 'yes'");

        auto kv = TMailUserJournalParser::TryParse("tskv\tdate=12345\tuid=1111\tv=2\tjunk=-\tsome=field\tfoo=bar");
        UNIT_ASSERT_VALUES_EQUAL(kv, TMailUserJournalRow({
                                         .Uid = 1111,
                                         .Date = 12345,
                                         .Tskv = NRowParsers::TTskvRow({
                                             {"date", "12345"},
                                             {"uid", "1111"},
                                             {"v", "2"},
                                             {"junk", ""},
                                             {"some", "field"},
                                             {"foo", "bar"},
                                         }),
                                     }));

        kv = TMailUserJournalParser::TryParse("tskv\tdate=12345\tuid=1111\tv=2\tfoo=asd\\tfgh");
        UNIT_ASSERT_VALUES_EQUAL(kv, TMailUserJournalRow({
                                         .Uid = 1111,
                                         .Date = 12345,
                                         .Tskv = NRowParsers::TTskvRow({
                                             {"date", "12345"},
                                             {"uid", "1111"},
                                             {"v", "2"},
                                             {"foo", "asd\\tfgh"},
                                         }),
                                     }));
    }
}

template <>
void Out<NPassport::NLbchdb::NParser::TMailUserJournalRow>(IOutputStream& o, const NPassport::NLbchdb::NParser::TMailUserJournalRow& value) {
    o << "uid=" << value.Uid << Endl;
    o << "date=" << value.Date << Endl;
    for (const auto& [key, value] : value.Tskv.Fields()) {
        o << key << " : " << value << Endl;
    }
}
