#include <passport/infra/daemons/lbchdb/src/parsers/push_parser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NParser;

Y_UNIT_TEST_SUITE(PushParser) {
    Y_UNIT_TEST(tryParseException) {
        struct TTestCase {
            TString Line;
            TString Exception;
        };

        std::vector<TTestCase> tests{
            TTestCase{
                .Line = "",
                .Exception = "line should start with 'tskv'",
            },
            TTestCase{
                .Line = "tskv\tunixtime=16000000\tpush_id=aaa\tsubscription_id=bbb",
                .Exception = "no field 'uid'",
            },
            TTestCase{
                .Line = "tskv\tuid=a11\tunixtime=16000000\tpush_id=aaa\tsubscription_id=bbb",
                .Exception = "invalid number in 'uid': 'a11'",
            },
            TTestCase{
                .Line = "tskv\tuid=111\tpush_id=aaa\tsubscription_id=bbb",
                .Exception = "no field 'unixtime'",
            },
            TTestCase{
                .Line = "tskv\tuid=111\tunixtime=16000000\tsubscription_id=bbb",
                .Exception = "no field 'push_id'",
            },
            TTestCase{
                .Line = "tskv\tuid=111\tunixtime=16000000\tpush_id=aaa",
                .Exception = "no field 'subscription_id'",
            },
        };

        for (const auto& test : tests) {
            UNIT_ASSERT_EXCEPTION_CONTAINS_C(TPushParser::TryParse(test.Line),
                                             yexception,
                                             test.Exception,
                                             "expected : " + test.Exception);
        }
    }

    Y_UNIT_TEST(tryParseGoodLine) {
        struct TTestCase {
            TString Line;
            TPushRow Row;
        };

        std::vector<TTestCase> tests;

        tests.emplace_back(TTestCase{
            .Line = "tskv\tuid=111\tunixtime=16000000\tpush_id=aaa\tsubscription_id=bbb",
            .Row = {.Uid = 111,
                    .Unixtime = TInstant::Seconds(16000000),
                    .PushId = "aaa",
                    .SubscriptionId = "bbb",
                    .Details = ""}});

        tests.emplace_back(TTestCase{
            .Line = "tskv\tuid=111\tunixtime=16000000\tpush_id=aaa\tsubscription_id=bbb\tapp_id=ccc\tdevice_id=ddd"
                    "\tsome=field\tpush_service=foo\tpush_event=bar\tcontext=some context\tstatus={status}\tdetails=true",
            .Row = {.Uid = 111,
                    .Unixtime = TInstant::Seconds(16000000),
                    .PushId = "aaa",
                    .SubscriptionId = "bbb",
                    .AppId = "ccc",
                    .DeviceId = "ddd",
                    .PushService = "foo",
                    .PushEvent = "bar",
                    .Details = "true",
                    .Status = "{status}",
                    .Context = "some context"}});

        for (const auto& test : tests) {
            auto res = TPushParser::TryParse(test.Line);
            UNIT_ASSERT(res.has_value());
            UNIT_ASSERT_VALUES_EQUAL(res.value(), test.Row);
        }
    }
}
