#include <passport/infra/daemons/lbchdb/src/parsers/push_subscription_parser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NParser;

Y_UNIT_TEST_SUITE(PushSubscriptionParser) {
    Y_UNIT_TEST(tryParseException) {
        struct TTestCase {
            TString Line;
            TString Exception;
        };

        std::vector<TTestCase> tests{
            TTestCase{
                .Line = "",
                .Exception = "line should start with 'tskv'",
            },
            TTestCase{
                .Line = "tskv\tunixtime=16000000\tpush_id=aaa\tsubscription_id=bbb",
                .Exception = "no field 'uid'",
            },
            TTestCase{
                .Line = "tskv\tuid=a11\tunixtime=16000000\tpush_id=aaa\tsubscription_id=bbb",
                .Exception = "invalid number in 'uid': 'a11'",
            },
            TTestCase{
                .Line = "tskv\tuid=111\tpush_id=aaa\tsubscription_id=bbb",
                .Exception = "no field 'unixtime'",
            },
            TTestCase{
                .Line = "tskv\tuid=111\tunixtime=16000000\tsubscription_id=bbb",
                .Exception = "no field 'app_id'",
            },
            TTestCase{
                .Line = "tskv\tuid=111\tunixtime=16000000\tapp_id=kek",
                .Exception = "no field 'device_id'",
            },
        };

        for (const auto& test : tests) {
            UNIT_ASSERT_EXCEPTION_CONTAINS_C(TPushSubscriptionParser::TryParse(test.Line),
                                             yexception,
                                             test.Exception,
                                             "expected : " + test.Exception);
        }
    }

    Y_UNIT_TEST(tryParseGoodLine) {
        UNIT_ASSERT_VALUES_EQUAL(
            TPushSubscriptionParser::TryParse("tskv\tuid=111\tunixtime=16000000\tapp_id=aaa\tdevice_id=bbb"),
            TPushSubscriptionRow({
                .Uid = 111,
                .AppId = "aaa",
                .DeviceId = "bbb",
                .Unixtime = TInstant::Seconds(16000000),
            }));
    }
}
