#include <passport/infra/daemons/lbchdb/src/sender_unsubsrcibe_lists.h>
#include <passport/infra/daemons/lbchdb/src/parsers/sender_delivery_parser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NParser;

Y_UNIT_TEST_SUITE(SenderDeliveryParser) {
    class TTestParser: public TSenderDeliveryParser {
    public:
        using TSenderDeliveryParser::ParseRow;
        using TSenderDeliveryParser::TryParse;
        using TSenderDeliveryParser::TSenderDeliveryParser;
    };

    Y_UNIT_TEST(tryParse) {
        TSenderUnsubscribeLists lists(R"({"asd":789})");

        TTestParser parser(lists);

        UNIT_ASSERT(!parser.ParseRow("tskv\tunixtime=100500\trecepient=vasya@yandex.ru\tstatus=something"));
        UNIT_ASSERT(parser.ParseRow("tskv\tunixtime=100505\trecepient=petya\\=@yandex.ru\tstatus=0\taccount=asd"));

        TTestParser::TResult expected(1);
        expected.back().RecipientEmail = R"(petya=@yandex.ru)";
        expected.back().UnsubscribeList = 789;
        expected.back().Ts = 100505;
        UNIT_ASSERT_VALUES_EQUAL(expected, parser.Parse({}));
    }
}

template <>
void Out<TSenderDeliveryRow>(IOutputStream& o, const TSenderDeliveryRow& value) {
    o << "recipient=" << value.RecipientEmail
      << ". unsubscribe_list=" << value.UnsubscribeList
      << ". ts=" << value.Ts
      << Endl;
}
