#include <passport/infra/daemons/lbchdb/src/sender_unsubsrcibe_lists.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;

Y_UNIT_TEST_SUITE(SenderUnsibscribeLists) {
    Y_UNIT_TEST(ctor) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TSenderUnsubscribeLists("{"),
            yexception,
            "malformed json: {");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TSenderUnsubscribeLists("{}"),
            yexception,
            "unsubscribe lists are empty");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TSenderUnsubscribeLists(R"({"asd": false})"),
            yexception,
            "account 'asd' is not uint64");

        UNIT_ASSERT_NO_EXCEPTION(TSenderUnsubscribeLists(R"({"asd": 42})"));
    }

    Y_UNIT_TEST(getByAccount) {
        TSenderUnsubscribeLists list(R"({"asd": 42, "qwe": 100500})");

        UNIT_ASSERT_VALUES_EQUAL(42, list.GetByAccount("asd"));
        UNIT_ASSERT_VALUES_EQUAL(100500, list.GetByAccount("qwe"));

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            list.GetByAccount("missing"),
            yexception,
            "sender account 'missing' is unknown");
    }
}
